"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _path = _interopRequireDefault(require("path"));

var _yargs = _interopRequireDefault(require("yargs"));

var _fp = require("lodash/fp");

var _lodash = require("lodash");

var _mjmlCore = _interopRequireWildcard(require("mjml-core"));

var _mjmlMigrate = _interopRequireDefault(require("mjml-migrate"));

var _mjmlValidator = _interopRequireDefault(require("mjml-validator"));

var _mjmlParserXml = _interopRequireDefault(require("mjml-parser-xml"));

var _readFile = _interopRequireWildcard(require("./commands/readFile"));

var _watchFiles = _interopRequireDefault(require("./commands/watchFiles"));

var _readStream = _interopRequireDefault(require("./commands/readStream"));

var _outputToFile = _interopRequireWildcard(require("./commands/outputToFile"));

var _outputToConsole = _interopRequireDefault(require("./commands/outputToConsole"));

var _package = require("mjml-core/package.json");

var _package2 = require("../package.json");

var _defaultOptions = _interopRequireDefault(require("./helpers/defaultOptions"));

// eslint-disable-line import/first
var _default = /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
  var EXIT_CODE, KEEP_OPEN, error, pickArgs, argv, juiceOptions, minifyOptions, juicePreserveTags, fonts, filePath, config, inputArgs, outputArgs, inputOpt, outputOpt, inputFiles, inputs, convertedStream, failedStream, isInvalid, fullOutputPath;
  return _regenerator["default"].wrap(function _callee$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          EXIT_CODE = 0;
          KEEP_OPEN = false;

          error = function error(msg) {
            console.error('\nCommand line error:'); // eslint-disable-line no-console

            console.error(msg); // eslint-disable-line no-console

            process.exit(1);
          };

          pickArgs = function pickArgs(args) {
            return (0, _fp.flow)((0, _fp.pick)(args), (0, _fp.pickBy)(function (e) {
              return (0, _fp.negate)(_fp.isNil)(e) && !((0, _lodash.isArray)(e) && (0, _lodash.isEmpty)(e));
            }));
          };

          argv = _yargs["default"].version(false) // cf. https://github.com/yargs/yargs/issues/961
          .options({
            r: {
              alias: 'read',
              describe: 'Compile MJML File(s)',
              type: 'array'
            },
            m: {
              alias: 'migrate',
              describe: 'Migrate MJML3 File(s)',
              type: 'array'
            },
            v: {
              alias: 'validate',
              describe: 'Run validator on File(s)',
              type: 'array'
            },
            w: {
              alias: 'watch',
              type: 'array',
              describe: 'Watch and compile MJML File(s) when modified'
            },
            i: {
              alias: 'stdin',
              describe: 'Compiles MJML from input stream'
            },
            s: {
              alias: 'stdout',
              describe: 'Output HTML to stdout'
            },
            o: {
              alias: 'output',
              type: 'string',
              describe: 'Filename/Directory to output compiled files'
            },
            c: {
              alias: 'config',
              type: 'object',
              describe: 'Option to pass to mjml-core'
            },
            version: {
              alias: 'V'
            }
          }).help().version("mjml-core: ".concat(_package.version, "\nmjml-cli: ").concat(_package2.version)).argv;

          try {
            juiceOptions = argv.c && argv.c.juiceOptions && JSON.parse(argv.c.juiceOptions);
          } catch (e) {
            error("Failed to decode JSON for config.juiceOptions argument");
          }

          try {
            minifyOptions = argv.c && argv.c.minifyOptions && JSON.parse(argv.c.minifyOptions);
          } catch (e) {
            error("Failed to decode JSON for config.minifyOptions argument");
          }

          try {
            juicePreserveTags = argv.c && argv.c.juicePreserveTags && JSON.parse(argv.c.juicePreserveTags);
          } catch (e) {
            error("Failed to decode JSON for config.juicePreserveTags argument");
          }

          try {
            fonts = argv.c && argv.c.fonts && JSON.parse(argv.c.fonts);
          } catch (e) {
            error("Failed to decode JSON for config.fonts argument");
          }

          filePath = argv.c && argv.c.filePath;
          config = Object.assign(_defaultOptions["default"], argv.c, fonts && {
            fonts: fonts
          }, minifyOptions && {
            minifyOptions: minifyOptions
          }, juiceOptions && {
            juiceOptions: juiceOptions
          }, juicePreserveTags && {
            juicePreserveTags: juicePreserveTags
          });
          inputArgs = pickArgs(['r', 'w', 'i', '_', 'm', 'v'])(argv);
          outputArgs = pickArgs(['o', 's'])(argv);
          [[Object.keys(inputArgs).length === 0, 'No input argument received'], [Object.keys(inputArgs).length > 1, 'Too many input arguments received'], [Object.keys(outputArgs).length > 1, 'Too many output arguments received'], [argv.w && argv.w.length > 1 && !argv.o, 'Need an output option when watching files'], [argv.w && argv.w.length > 1 && argv.o && !(0, _outputToFile.isDirectory)(argv.o) && argv.o !== '', 'Need an output option when watching files']].forEach(function (v) {
            return v[0] ? error(v[1]) : null;
          });
          inputOpt = Object.keys(inputArgs)[0];
          outputOpt = Object.keys(outputArgs)[0] || 's';
          inputFiles = (0, _lodash.isArray)(inputArgs[inputOpt]) ? inputArgs[inputOpt] : [inputArgs[inputOpt]];
          inputs = [];
          _context.t0 = inputOpt;
          _context.next = _context.t0 === 'r' ? 21 : _context.t0 === 'v' ? 21 : _context.t0 === 'm' ? 21 : _context.t0 === '_' ? 21 : _context.t0 === 'w' ? 26 : _context.t0 === 'i' ? 29 : 35;
          break;

        case 21:
          (0, _readFile.flatMapPaths)(inputFiles).forEach(function (file) {
            inputs.push((0, _readFile["default"])(file));
          });

          if (inputs.length) {
            _context.next = 25;
            break;
          }

          error('No input files found');
          return _context.abrupt("return");

        case 25:
          return _context.abrupt("break", 36);

        case 26:
          (0, _watchFiles["default"])(inputFiles, (0, _objectSpread2["default"])({}, argv, {
            config: config
          }));
          KEEP_OPEN = true;
          return _context.abrupt("break", 36);

        case 29:
          _context.t1 = inputs;
          _context.next = 32;
          return (0, _readStream["default"])();

        case 32:
          _context.t2 = _context.sent;

          _context.t1.push.call(_context.t1, _context.t2);

          return _context.abrupt("break", 36);

        case 35:
          error('Command line error: Incorrect input options');

        case 36:
          convertedStream = [];
          failedStream = [];
          inputs.forEach(function (i) {
            try {
              var compiled;

              switch (inputOpt) {
                case 'm':
                  // eslint-disable-line no-case-declarations
                  compiled = {
                    html: (0, _mjmlMigrate["default"])(i.mjml, {
                      beautify: true
                    })
                  };
                  break;

                case 'v':
                  // eslint-disable-line no-case-declarations
                  var mjmlJson = (0, _mjmlParserXml["default"])(i.mjml, {
                    components: _mjmlCore.components
                  });
                  compiled = {
                    errors: (0, _mjmlValidator["default"])(mjmlJson, {
                      components: _mjmlCore.components,
                      initializeType: _mjmlCore.initializeType
                    })
                  };
                  break;

                default:
                  compiled = (0, _mjmlCore["default"])(i.mjml, (0, _objectSpread2["default"])({}, config, {
                    filePath: filePath || i.file,
                    actualPath: i.file
                  }));
              }

              convertedStream.push((0, _objectSpread2["default"])({}, i, {
                compiled: compiled
              }));
            } catch (e) {
              EXIT_CODE = 2;
              failedStream.push({
                file: i.file,
                error: e
              });
            }
          });
          convertedStream.forEach(function (s) {
            if ((0, _lodash.get)(s, 'compiled.errors.length')) {
              console.error((0, _lodash.map)(s.compiled.errors, 'formattedMessage').join('\n')); // eslint-disable-line no-console
            }
          });
          failedStream.forEach(function (_ref2) {
            var error = _ref2.error,
                file = _ref2.file;
            // eslint-disable-line array-callback-return
            console.error("".concat(file ? "File: ".concat(file, "\n") : null).concat(error)); // eslint-disable-line no-console

            if (config.stack) {
              console.error(error.stack); // eslint-disable-line no-console
            }
          });

          if (!(inputOpt === 'v')) {
            _context.next = 48;
            break;
          }

          isInvalid = failedStream.length || convertedStream.some(function (s) {
            return !!(0, _lodash.get)(s, 'compiled.errors.length');
          });

          if (!isInvalid) {
            _context.next = 46;
            break;
          }

          error('Validation failed');
          return _context.abrupt("return");

        case 46:
          process.exitCode = 0;
          return _context.abrupt("return");

        case 48:
          if (!KEEP_OPEN && convertedStream.length === 0) {
            error('Input file(s) failed to render');
          }

          _context.t3 = outputOpt;
          _context.next = _context.t3 === 'o' ? 52 : _context.t3 === 's' ? 57 : 59;
          break;

        case 52:
          if (inputs.length > 1 && !(0, _outputToFile.isDirectory)(argv.o) && argv.o !== '') {
            error("Multiple input files, but output option should be either an existing directory or an empty string: ".concat(argv.o, " given"));
          }

          fullOutputPath = _path["default"].parse(_path["default"].resolve(process.cwd(), argv.o));

          if (inputs.length === 1 && !(0, _outputToFile.isDirectory)(fullOutputPath.dir)) {
            error("Output directory doesn\u2019t exist for path : ".concat(argv.o));
          }

          Promise.all(convertedStream.map((0, _outputToFile["default"])(argv.o))).then(function () {
            if (!KEEP_OPEN) {
              process.exitCode = EXIT_CODE;
            }
          })["catch"](function (_ref3) {
            var outputName = _ref3.outputName,
                err = _ref3.err;

            if (!KEEP_OPEN) {
              error("Error writing file - ".concat(outputName, " : ").concat(err));
            }
          });
          return _context.abrupt("break", 60);

        case 57:
          Promise.all(convertedStream.map(_outputToConsole["default"])).then(function () {
            return process.exitCode = EXIT_CODE;
          }) // eslint-disable-line no-return-assign
          ["catch"](function () {
            return process.exitCode = 1;
          }); // eslint-disable-line no-return-assign

          return _context.abrupt("break", 60);

        case 59:
          error('Command line error: No output option available');

        case 60:
        case "end":
          return _context.stop();
      }
    }
  }, _callee);
}));

exports["default"] = _default;
module.exports = exports.default;