"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.isDirectory = void 0;

var _fs = _interopRequireDefault(require("fs"));

var _path = _interopRequireDefault(require("path"));

var isDirectory = function isDirectory(file) {
  try {
    var outputPath = _path["default"].resolve(process.cwd(), file);

    return _fs["default"].statSync(outputPath).isDirectory();
  } catch (e) {
    return false;
  }
};

exports.isDirectory = isDirectory;

var replaceExtension = function replaceExtension(input) {
  return input.replace('.mjml', input.replace('.mjml', '').match(/(.)*\.(.)+$/g) ? '' : '.html');
};

var stripPath = function stripPath(input) {
  return input.match(/[^/\\]+$/g)[0];
};

var makeGuessOutputName = function makeGuessOutputName(outputPath) {
  if (isDirectory(outputPath)) {
    return function (input) {
      return _path["default"].join(outputPath, replaceExtension(stripPath(input)));
    };
  }

  return function (input) {
    if (!outputPath) {
      return replaceExtension(stripPath(input));
    }

    return outputPath;
  };
};

var _default = function _default(outputPath) {
  var guessOutputName = makeGuessOutputName(outputPath);
  return function (_ref) {
    var file = _ref.file,
        html = _ref.compiled.html;
    return new Promise(function (resolve, reject) {
      var outputName = guessOutputName(file);

      _fs["default"].writeFile(outputName, html, function (err) {
        if (err) {
          return reject({
            outputName: outputName,
            err: err
          });
        }

        return resolve(outputName);
      });
    });
  };
};

exports["default"] = _default;