"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.flatMapPaths = void 0;

var _fs = _interopRequireDefault(require("fs"));

var _glob = _interopRequireDefault(require("glob"));

var _lodash = require("lodash");

var flatMapPaths = function flatMapPaths(paths) {
  return (0, _lodash.flatMap)(paths, function (p) {
    return _glob["default"].sync(p, {
      nodir: true
    });
  });
};

exports.flatMapPaths = flatMapPaths;

var _default = function _default(path) {
  try {
    return {
      file: path,
      mjml: _fs["default"].readFileSync(path).toString()
    };
  } catch (e) {
    // eslint-disable-next-line
    console.warn("Cannot read file: ".concat(path, " doesn't exist or no access"), e);
    return {};
  }
};

exports["default"] = _default;