"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _chokidar = _interopRequireDefault(require("chokidar"));

var _glob = _interopRequireDefault(require("glob"));

var _path = _interopRequireDefault(require("path"));

var _mjmlCore = _interopRequireDefault(require("mjml-core"));

var _fp = require("lodash/fp");

var _readFile = _interopRequireDefault(require("./readFile"));

var _outputToFile = _interopRequireDefault(require("./outputToFile"));

var _fileContext = _interopRequireDefault(require("../helpers/fileContext"));

/* eslint-disable no-console */
var dirty = [];

var _flatMap = _fp.flatMap.convert({
  cap: false
}); // eslint-disable-line no-underscore-dangle


var flatMapAndJoin = _flatMap(function (v, k) {
  return v.map(function (p) {
    return _path["default"].join(k, p);
  });
});

var flatMapKeyAndValues = (0, _fp.flow)(_flatMap(function (v, k) {
  return [k].concat((0, _toConsumableArray2["default"])(v));
}), _fp.uniq);

var _default = function _default(input, options) {
  console.log("Now watching: ".concat(input));
  var dependencies = {};
  var outputToFile = (0, _outputToFile["default"])(options.o);

  var getRelatedFiles = function getRelatedFiles(file) {
    return (0, _fp.flow)((0, _fp.pickBy)(function (v, k) {
      return k === file || v.indexOf(file) !== -1;
    }), Object.keys)(dependencies);
  };

  var synchronyzeWatcher = function synchronyzeWatcher(filePath) {
    getRelatedFiles(filePath).forEach(function (f) {
      dependencies[f] = (0, _fileContext["default"])(f, options.config.filePath);

      if (dirty.indexOf(f) === -1) {
        dirty.push(f);
      }
    });
    /* eslint-disable no-use-before-define */

    var files = {
      toWatch: flatMapKeyAndValues(dependencies),
      watched: flatMapAndJoin(watcher.getWatched())
    };
    watcher.add((0, _fp.difference)(files.toWatch, files.watched));
    watcher.unwatch((0, _fp.difference)(files.watched, files.toWatch));
    /* eslint-enable no-use-before-define */
  };

  var readAndCompile = (0, _fp.flow)(function (file) {
    return {
      file: file,
      content: (0, _readFile["default"])(file).mjml
    };
  }, function (args) {
    return (0, _objectSpread2["default"])({}, args, {
      compiled: (0, _mjmlCore["default"])(args.content, (0, _objectSpread2["default"])({
        filePath: args.file,
        actualPath: args.file
      }, options.config))
    });
  }, function (args) {
    var errors = args.compiled.errors;
    errors.forEach(function (e) {
      return console.warn(e.formattedMessage);
    });
    return args;
  }, function (args) {
    return outputToFile(args).then(function () {
      return console.log("".concat(args.file, " - Successfully compiled"));
    })["catch"](function () {
      return console.log("".concat(args.file, " - Error while compiling file"));
    });
  });

  var watcher = _chokidar["default"].watch(input.map(function (i) {
    return i.replace(/\\/g, '/');
  })).on('change', function (file) {
    return synchronyzeWatcher(_path["default"].resolve(file));
  }).on('add', function (file) {
    var filePath = _path["default"].resolve(file);

    var matchInputOption = input.reduce(function (found, file) {
      return found || (0, _glob["default"])(_path["default"].resolve(file)).minimatch.match(filePath);
    }, false);

    if (matchInputOption) {
      dependencies[filePath] = getRelatedFiles(filePath);
    }

    synchronyzeWatcher(filePath);
  }).on('unlink', function (file) {
    var filePath = _path["default"].resolve(file);

    delete dependencies[_path["default"].resolve(filePath)];
    (0, _fp.remove)(dirty, function (f) {
      return f === filePath;
    });
    synchronyzeWatcher(filePath);
  });

  setInterval(function () {
    dirty.forEach(function (f) {
      console.log("".concat(f, " - Change detected"));

      try {
        readAndCompile(f);
      } catch (e) {
        console.log("".concat(f, " - Error while rendering the file : "), e);
      }
    });
    dirty = [];
  }, 500);
  return [];
};
/* eslint-enable no-console */


exports["default"] = _default;
module.exports = exports.default;