"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _fs = _interopRequireDefault(require("fs"));

var _path = _interopRequireDefault(require("path"));

var includeRegexp = /<mj-include\s+path=['"](.*[.mjml]?)['"]\s*(\/>|>\s*<\/mj-include>)/g;

var ensureIncludeIsMJMLFile = function ensureIncludeIsMJMLFile(file) {
  return file.trim().match(/.mjml/) && file || "".concat(file, ".mjml");
};

var error = function error(e) {
  return console.error(e.stack || e);
}; // eslint-disable-line no-console


var _default = function _default(baseFile, filePath) {
  var filesIncluded = [];
  var filePathDirectory = '';

  if (filePath) {
    try {
      var isFilePathDir = _fs["default"].lstatSync(filePath).isDirectory();

      filePathDirectory = isFilePathDir ? filePath : _path["default"].dirname(filePath);
    } catch (e) {
      if (e.code === 'ENOENT') {
        throw new Error('Specified filePath does not exist');
      } else {
        throw e;
      }
    }
  }

  var readIncludes = function readIncludes(dir, file, base) {
    var currentFile = _path["default"].resolve(dir ? _path["default"].join(dir, ensureIncludeIsMJMLFile(file)) : ensureIncludeIsMJMLFile(file));

    var currentDirectory = _path["default"].dirname(currentFile);

    var includes = new RegExp(includeRegexp);
    var content;

    try {
      content = _fs["default"].readFileSync(currentFile, 'utf8');
    } catch (e) {
      error("File not found ".concat(currentFile, " from ").concat(base));
      return;
    }

    var matchgroup = includes.exec(content);

    while (matchgroup != null) {
      var includedFile = ensureIncludeIsMJMLFile(matchgroup[1]); // when reading first level of includes we must join the path specified in filePath
      // when reading further nested includes, just take parent dir as base

      var targetDir = filePath && file === baseFile ? filePathDirectory : currentDirectory;

      var includedFilePath = _path["default"].resolve(_path["default"].join(targetDir, includedFile));

      filesIncluded.push(includedFilePath);
      readIncludes(targetDir, includedFile, currentFile);
      matchgroup = includes.exec(content);
    }
  };

  readIncludes(null, baseFile, baseFile);
  return filesIncluded;
};

exports["default"] = _default;
module.exports = exports.default;