'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _class, _temp;

var _mjmlCore = require('mjml-core');

var _widthParser5 = require('mjml-core/lib/helpers/widthParser');

var _widthParser6 = _interopRequireDefault(_widthParser5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MjColumn = (_temp = _class = function (_BodyComponent) {
  (0, _inherits3.default)(MjColumn, _BodyComponent);

  function MjColumn() {
    (0, _classCallCheck3.default)(this, MjColumn);
    return (0, _possibleConstructorReturn3.default)(this, (MjColumn.__proto__ || (0, _getPrototypeOf2.default)(MjColumn)).apply(this, arguments));
  }

  (0, _createClass3.default)(MjColumn, [{
    key: 'getChildContext',
    value: function getChildContext() {
      var parentWidth = this.context.containerWidth;
      var nonRawSiblings = this.props.nonRawSiblings;


      var paddingSize = this.getShorthandAttrValue('padding', 'left') + this.getShorthandAttrValue('padding', 'right');

      var containerWidth = this.getAttribute('width') || parseFloat(parentWidth) / nonRawSiblings + 'px';

      var _widthParser = (0, _widthParser6.default)(containerWidth, {
        parseFloatToInt: false
      }),
          unit = _widthParser.unit,
          parsedWidth = _widthParser.parsedWidth;

      if (unit === '%') {
        containerWidth = parseFloat(parentWidth) * parsedWidth / 100 - paddingSize + 'px';
      } else {
        containerWidth = parsedWidth - paddingSize + 'px';
      }

      return (0, _extends3.default)({}, this.context, {
        containerWidth: containerWidth
      });
    }
  }, {
    key: 'getStyles',
    value: function getStyles() {
      var tableStyle = {
        'background-color': this.getAttribute('background-color'),
        border: this.getAttribute('border'),
        'border-bottom': this.getAttribute('border-bottom'),
        'border-left': this.getAttribute('border-left'),
        'border-radius': this.getAttribute('border-radius'),
        'border-right': this.getAttribute('border-right'),
        'border-top': this.getAttribute('border-top'),
        'vertical-align': this.getAttribute('vertical-align')
      };

      return {
        div: {
          'font-size': '13px',
          'text-align': 'left',
          direction: this.getAttribute('direction'),
          display: 'inline-block',
          'vertical-align': this.getAttribute('vertical-align'),
          width: this.getMobileWidth()
        },
        table: (0, _extends3.default)({}, this.hasGutter() ? {} : tableStyle),
        tdOutlook: {
          'vertical-align': this.getAttribute('vertical-align'),
          width: this.getWidthAsPixel()
        },
        gutter: (0, _extends3.default)({}, tableStyle, {
          padding: this.getAttribute('padding'),
          'padding-top': this.getAttribute('padding-top'),
          'padding-right': this.getAttribute('padding-right'),
          'padding-bottom': this.getAttribute('padding-bottom'),
          'padding-left': this.getAttribute('padding-left')
        })
      };
    }
  }, {
    key: 'getMobileWidth',
    value: function getMobileWidth() {
      var _context = this.context,
          nonRawSiblings = _context.nonRawSiblings,
          containerWidth = _context.containerWidth;

      var width = this.getAttribute('width');
      var mobileWidth = this.getAttribute('mobileWidth');

      if (mobileWidth !== 'mobileWidth') {
        return '100%';
      } else if (width === undefined) {
        return parseInt(100 / nonRawSiblings, 10) + '%';
      }

      var _widthParser2 = (0, _widthParser6.default)(width, {
        parseFloatToInt: false
      }),
          unit = _widthParser2.unit,
          parsedWidth = _widthParser2.parsedWidth;

      switch (unit) {
        case '%':
          return width;
        case 'px':
        default:
          return parsedWidth / parseInt(containerWidth, 10) + '%';
      }
    }
  }, {
    key: 'getWidthAsPixel',
    value: function getWidthAsPixel() {
      var containerWidth = this.context.containerWidth;

      var _widthParser3 = (0, _widthParser6.default)(this.getParsedWidth(true), {
        parseFloatToInt: false
      }),
          unit = _widthParser3.unit,
          parsedWidth = _widthParser3.parsedWidth;

      if (unit === '%') {
        return parseFloat(containerWidth) * parsedWidth / 100 + 'px';
      }
      return parsedWidth + 'px';
    }
  }, {
    key: 'getParsedWidth',
    value: function getParsedWidth(toString) {
      var nonRawSiblings = this.props.nonRawSiblings;


      var width = this.getAttribute('width') || 100 / nonRawSiblings + '%';

      var _widthParser4 = (0, _widthParser6.default)(width, {
        parseFloatToInt: false
      }),
          unit = _widthParser4.unit,
          parsedWidth = _widthParser4.parsedWidth;

      if (toString) {
        return '' + parsedWidth + unit;
      }

      return {
        unit: unit,
        parsedWidth: parsedWidth
      };
    }
  }, {
    key: 'getColumnClass',
    value: function getColumnClass() {
      var addMediaQuery = this.context.addMediaQuery;


      var className = '';

      var _getParsedWidth = this.getParsedWidth(),
          parsedWidth = _getParsedWidth.parsedWidth,
          unit = _getParsedWidth.unit;

      switch (unit) {
        case '%':
          className = 'mj-column-per-' + parseInt(parsedWidth, 10);
          break;

        case 'px':
        default:
          className = 'mj-column-px-' + parseInt(parsedWidth, 10);
          break;
      }

      // Add className to media queries
      addMediaQuery(className, {
        parsedWidth: parsedWidth,
        unit: unit
      });

      return className;
    }
  }, {
    key: 'hasGutter',
    value: function hasGutter() {
      var _this2 = this;

      return ['padding', 'padding-bottom', 'padding-left', 'padding-right', 'padding-top'].some(function (attr) {
        return _this2.getAttribute(attr) != null;
      });
    }
  }, {
    key: 'renderGutter',
    value: function renderGutter() {
      return '\n      <table\n        ' + this.htmlAttributes({
        background: this.getAttribute('background-color'),
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        width: '100%'
      }) + '\n      >\n        <tbody>\n          <tr>\n            <td ' + this.htmlAttributes({ style: 'gutter' }) + '>\n              ' + this.renderColumn() + '\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    ';
    }
  }, {
    key: 'renderColumn',
    value: function renderColumn() {
      var children = this.props.children;


      return '\n      <table\n        ' + this.htmlAttributes({
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        style: 'table',
        width: '100%'
      }) + '\n      >\n        ' + this.renderChildren(children, {
        renderer: function renderer(component) {
          return (// eslint-disable-line no-confusing-arrow
            component.constructor.isRawElement() ? component.render() : '\n            <tr>\n              <td\n                ' + component.htmlAttributes({
              align: component.getAttribute('align'),
              'vertical-align': component.getAttribute('vertical-align'),
              class: component.getAttribute('css-class'),
              style: {
                background: component.getAttribute('container-background-color'),
                'font-size': '0px',
                padding: component.getAttribute('padding'),
                'padding-top': component.getAttribute('padding-top'),
                'padding-right': component.getAttribute('padding-right'),
                'padding-bottom': component.getAttribute('padding-bottom'),
                'padding-left': component.getAttribute('padding-left'),
                'word-break': 'break-word'
              }
            }) + '\n              >\n                ' + component.render() + '\n              </td>\n            </tr>\n          '
          );
        }
      }) + '\n      </table>\n    ';
    }
  }, {
    key: 'render',
    value: function render() {
      var classesName = this.getColumnClass() + ' outlook-group-fix';

      if (this.getAttribute('css-class')) {
        classesName += ' ' + this.getAttribute('css-class');
      }

      return '\n      <div\n        ' + this.htmlAttributes({
        class: classesName,
        style: 'div'
      }) + '\n      >\n        ' + (this.hasGutter() ? this.renderGutter() : this.renderColumn()) + '\n      </div>\n    ';
    }
  }]);
  return MjColumn;
}(_mjmlCore.BodyComponent), _class.allowedAttributes = {
  'background-color': 'color',
  border: 'string',
  'border-bottom': 'string',
  'border-left': 'string',
  'border-radius': 'unit(px,%)',
  'border-right': 'string',
  'border-top': 'string',
  direction: 'enum(ltr,rtl)',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  padding: 'unit(px,%){1,4}',
  'vertical-align': 'enum(top,bottom,middle)',
  width: 'unit(px,%)'
}, _class.defaultAttributes = {
  direction: 'ltr',
  'vertical-align': 'top'
}, _temp);
exports.default = MjColumn;
module.exports = exports['default'];