"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var _widthParser5 = _interopRequireDefault(require("mjml-core/lib/helpers/widthParser"));

var MjColumn = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjColumn, _BodyComponent);

  function MjColumn() {
    (0, _classCallCheck2["default"])(this, MjColumn);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjColumn).apply(this, arguments));
  }

  (0, _createClass2["default"])(MjColumn, [{
    key: "getChildContext",
    value: function getChildContext() {
      var parentWidth = this.context.containerWidth;
      var nonRawSiblings = this.props.nonRawSiblings;

      var _this$getBoxWidths = this.getBoxWidths(),
          borders = _this$getBoxWidths.borders,
          paddings = _this$getBoxWidths.paddings;

      var innerBorders = this.getShorthandAttrValue('inner-border', 'left') + this.getShorthandAttrValue('inner-border', 'right');
      var allPaddings = paddings + borders + innerBorders;
      var containerWidth = this.getAttribute('width') || "".concat(parseFloat(parentWidth) / nonRawSiblings, "px");

      var _widthParser = (0, _widthParser5["default"])(containerWidth, {
        parseFloatToInt: false
      }),
          unit = _widthParser.unit,
          parsedWidth = _widthParser.parsedWidth;

      if (unit === '%') {
        containerWidth = "".concat(parseFloat(parentWidth) * parsedWidth / 100 - allPaddings, "px");
      } else {
        containerWidth = "".concat(parsedWidth - allPaddings, "px");
      }

      return (0, _objectSpread2["default"])({}, this.context, {
        containerWidth: containerWidth
      });
    }
  }, {
    key: "getStyles",
    value: function getStyles() {
      var tableStyle = {
        'background-color': this.getAttribute('background-color'),
        border: this.getAttribute('border'),
        'border-bottom': this.getAttribute('border-bottom'),
        'border-left': this.getAttribute('border-left'),
        'border-radius': this.getAttribute('border-radius'),
        'border-right': this.getAttribute('border-right'),
        'border-top': this.getAttribute('border-top'),
        'vertical-align': this.getAttribute('vertical-align')
      };
      return {
        div: {
          'font-size': '0px',
          'text-align': 'left',
          direction: this.getAttribute('direction'),
          display: 'inline-block',
          'vertical-align': this.getAttribute('vertical-align'),
          width: this.getMobileWidth()
        },
        table: (0, _objectSpread2["default"])({}, this.hasGutter() ? {
          'background-color': this.getAttribute('inner-background-color'),
          border: this.getAttribute('inner-border'),
          'border-bottom': this.getAttribute('inner-border-bottom'),
          'border-left': this.getAttribute('inner-border-left'),
          'border-radius': this.getAttribute('inner-border-radius'),
          'border-right': this.getAttribute('inner-border-right'),
          'border-top': this.getAttribute('inner-border-top')
        } : tableStyle),
        tdOutlook: {
          'vertical-align': this.getAttribute('vertical-align'),
          width: this.getWidthAsPixel()
        },
        gutter: (0, _objectSpread2["default"])({}, tableStyle, {
          padding: this.getAttribute('padding'),
          'padding-top': this.getAttribute('padding-top'),
          'padding-right': this.getAttribute('padding-right'),
          'padding-bottom': this.getAttribute('padding-bottom'),
          'padding-left': this.getAttribute('padding-left')
        })
      };
    }
  }, {
    key: "getMobileWidth",
    value: function getMobileWidth() {
      var containerWidth = this.context.containerWidth;
      var nonRawSiblings = this.props.nonRawSiblings;
      var width = this.getAttribute('width');
      var mobileWidth = this.getAttribute('mobileWidth');

      if (mobileWidth !== 'mobileWidth') {
        return '100%';
      } else if (width === undefined) {
        return "".concat(parseInt(100 / nonRawSiblings, 10), "%");
      }

      var _widthParser2 = (0, _widthParser5["default"])(width, {
        parseFloatToInt: false
      }),
          unit = _widthParser2.unit,
          parsedWidth = _widthParser2.parsedWidth;

      switch (unit) {
        case '%':
          return width;

        case 'px':
        default:
          return "".concat(parsedWidth / parseInt(containerWidth, 10), "%");
      }
    }
  }, {
    key: "getWidthAsPixel",
    value: function getWidthAsPixel() {
      var containerWidth = this.context.containerWidth;

      var _widthParser3 = (0, _widthParser5["default"])(this.getParsedWidth(true), {
        parseFloatToInt: false
      }),
          unit = _widthParser3.unit,
          parsedWidth = _widthParser3.parsedWidth;

      if (unit === '%') {
        return "".concat(parseFloat(containerWidth) * parsedWidth / 100, "px");
      }

      return "".concat(parsedWidth, "px");
    }
  }, {
    key: "getParsedWidth",
    value: function getParsedWidth(toString) {
      var nonRawSiblings = this.props.nonRawSiblings;
      var width = this.getAttribute('width') || "".concat(100 / nonRawSiblings, "%");

      var _widthParser4 = (0, _widthParser5["default"])(width, {
        parseFloatToInt: false
      }),
          unit = _widthParser4.unit,
          parsedWidth = _widthParser4.parsedWidth;

      if (toString) {
        return "".concat(parsedWidth).concat(unit);
      }

      return {
        unit: unit,
        parsedWidth: parsedWidth
      };
    }
  }, {
    key: "getColumnClass",
    value: function getColumnClass() {
      var addMediaQuery = this.context.addMediaQuery;
      var className = '';

      var _this$getParsedWidth = this.getParsedWidth(),
          parsedWidth = _this$getParsedWidth.parsedWidth,
          unit = _this$getParsedWidth.unit;

      var formattedClassNb = parsedWidth.toString().replace('.', '-');

      switch (unit) {
        case '%':
          className = "mj-column-per-".concat(formattedClassNb);
          break;

        case 'px':
        default:
          className = "mj-column-px-".concat(formattedClassNb);
          break;
      } // Add className to media queries


      addMediaQuery(className, {
        parsedWidth: parsedWidth,
        unit: unit
      });
      return className;
    }
  }, {
    key: "hasGutter",
    value: function hasGutter() {
      var _this = this;

      return ['padding', 'padding-bottom', 'padding-left', 'padding-right', 'padding-top'].some(function (attr) {
        return _this.getAttribute(attr) != null;
      });
    }
  }, {
    key: "renderGutter",
    value: function renderGutter() {
      return "\n      <table\n        ".concat(this.htmlAttributes({
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        width: '100%'
      }), "\n      >\n        <tbody>\n          <tr>\n            <td ").concat(this.htmlAttributes({
        style: 'gutter'
      }), ">\n              ").concat(this.renderColumn(), "\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    ");
    }
  }, {
    key: "renderColumn",
    value: function renderColumn() {
      var children = this.props.children;
      return "\n      <table\n        ".concat(this.htmlAttributes({
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        style: 'table',
        width: '100%'
      }), "\n      >\n        ").concat(this.renderChildren(children, {
        renderer: function renderer(component) {
          return (// eslint-disable-line no-confusing-arrow
            component.constructor.isRawElement() ? component.render() : "\n            <tr>\n              <td\n                ".concat(component.htmlAttributes({
              align: component.getAttribute('align'),
              'vertical-align': component.getAttribute('vertical-align'),
              "class": component.getAttribute('css-class'),
              style: {
                background: component.getAttribute('container-background-color'),
                'font-size': '0px',
                padding: component.getAttribute('padding'),
                'padding-top': component.getAttribute('padding-top'),
                'padding-right': component.getAttribute('padding-right'),
                'padding-bottom': component.getAttribute('padding-bottom'),
                'padding-left': component.getAttribute('padding-left'),
                'word-break': 'break-word'
              }
            }), "\n              >\n                ").concat(component.render(), "\n              </td>\n            </tr>\n          ")
          );
        }
      }), "\n      </table>\n    ");
    }
  }, {
    key: "render",
    value: function render() {
      var classesName = "".concat(this.getColumnClass(), " mj-outlook-group-fix");

      if (this.getAttribute('css-class')) {
        classesName += " ".concat(this.getAttribute('css-class'));
      }

      return "\n      <div\n        ".concat(this.htmlAttributes({
        "class": classesName,
        style: 'div'
      }), "\n      >\n        ").concat(this.hasGutter() ? this.renderGutter() : this.renderColumn(), "\n      </div>\n    ");
    }
  }]);
  return MjColumn;
}(_mjmlCore.BodyComponent);

exports["default"] = MjColumn;
(0, _defineProperty2["default"])(MjColumn, "allowedAttributes", {
  'background-color': 'color',
  border: 'string',
  'border-bottom': 'string',
  'border-left': 'string',
  'border-radius': 'unit(px,%){1,4}',
  'border-right': 'string',
  'border-top': 'string',
  direction: 'enum(ltr,rtl)',
  'inner-background-color': 'color',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  'inner-border': 'string',
  'inner-border-bottom': 'string',
  'inner-border-left': 'string',
  'inner-border-radius': 'unit(px,%){1,4}',
  'inner-border-right': 'string',
  'inner-border-top': 'string',
  padding: 'unit(px,%){1,4}',
  'vertical-align': 'enum(top,bottom,middle)',
  width: 'unit(px,%)'
});
(0, _defineProperty2["default"])(MjColumn, "defaultAttributes", {
  direction: 'ltr',
  'vertical-align': 'top'
});
module.exports = exports.default;