'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = buildMediaQueriesTags;

var _lodash = require('lodash');

// eslint-disable-next-line import/prefer-default-export
function buildMediaQueriesTags(breakpoint) {
  var mediaQueries = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var forceOWADesktop = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  if ((0, _lodash.isEmpty)(mediaQueries)) {
    return '';
  }

  var baseMediaQueries = (0, _lodash.map)(mediaQueries, function (mediaQuery, className) {
    return '.' + className + ' ' + mediaQuery;
  });
  var owaQueries = (0, _lodash.map)(baseMediaQueries, function (mq) {
    return '[owa] ' + mq;
  });

  return '\n    <style type="text/css">\n      @media only screen and (min-width:' + breakpoint + ') {\n        ' + baseMediaQueries.join('\n') + '\n      }\n    </style>\n    ' + (forceOWADesktop ? '<style type="text/css">\n' + owaQueries.join('\n') + '\n</style>' : '') + '\n  ';
}
module.exports = exports['default'];