'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = skeleton;

var _lodash = require('lodash');

var _preview = require('./preview');

var _preview2 = _interopRequireDefault(_preview);

var _fonts = require('./fonts');

var _mediaQueries = require('./mediaQueries');

var _mediaQueries2 = _interopRequireDefault(_mediaQueries);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function skeleton(options) {
  var _options$backgroundCo = options.backgroundColor,
      backgroundColor = _options$backgroundCo === undefined ? '' : _options$backgroundCo,
      _options$breakpoint = options.breakpoint,
      breakpoint = _options$breakpoint === undefined ? '480px' : _options$breakpoint,
      _options$content = options.content,
      content = _options$content === undefined ? '' : _options$content,
      _options$fonts = options.fonts,
      fonts = _options$fonts === undefined ? {} : _options$fonts,
      _options$mediaQueries = options.mediaQueries,
      mediaQueries = _options$mediaQueries === undefined ? {} : _options$mediaQueries,
      _options$headStyle = options.headStyle,
      headStyle = _options$headStyle === undefined ? [] : _options$headStyle,
      _options$componentsHe = options.componentsHeadStyle,
      componentsHeadStyle = _options$componentsHe === undefined ? {} : _options$componentsHe,
      _options$headRaw = options.headRaw,
      headRaw = _options$headRaw === undefined ? [] : _options$headRaw,
      preview = options.preview,
      _options$title = options.title,
      title = _options$title === undefined ? '' : _options$title,
      style = options.style,
      forceOWADesktop = options.forceOWADesktop,
      inlineStyle = options.inlineStyle,
      lang = options.lang;


  var langAttribute = lang ? 'lang="' + lang + '" ' : '';

  return '\n    <!doctype html>\n    <html ' + langAttribute + 'xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">\n      <head>\n        <title>\n          ' + title + '\n        </title>\n        <!--[if !mso]><!-- -->\n        <meta http-equiv="X-UA-Compatible" content="IE=edge">\n        <!--<![endif]-->\n        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">\n        <meta name="viewport" content="width=device-width, initial-scale=1">\n        <style type="text/css">\n          #outlook a { padding:0; }\n          body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\n          table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\n          img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\n          p { display:block;margin:13px 0; }\n        </style>\n        <!--[if mso]>\n        <xml>\n        <o:OfficeDocumentSettings>\n          <o:AllowPNG/>\n          <o:PixelsPerInch>96</o:PixelsPerInch>\n        </o:OfficeDocumentSettings>\n        </xml>\n        <![endif]-->\n        <!--[if lte mso 11]>\n        <style type="text/css">\n          .outlook-group-fix { width:100% !important; }\n        </style>\n        <![endif]-->\n        ' + (0, _fonts.buildFontsTags)(content, inlineStyle, fonts) + '\n        ' + (0, _mediaQueries2.default)(breakpoint, mediaQueries, forceOWADesktop) + '\n        <style type="text/css">\n        ' + (0, _lodash.reduce)(componentsHeadStyle, function (result, compHeadStyle) {
    return result + '\n' + compHeadStyle(breakpoint);
  }, '') + '\n        ' + (0, _lodash.reduce)(headStyle, function (result, headStyle) {
    return result + '\n' + headStyle(breakpoint);
  }, '') + '\n        </style>\n        ' + (style && style.length > 0 ? '<style type="text/css">' + style.join('') + '</style>' : '') + '\n        ' + headRaw.filter((0, _lodash.negate)(_lodash.isNil)).join('\n') + '\n      </head>\n      <body' + (backgroundColor === '' ? '' : ' style="background-color:' + backgroundColor + ';"') + '>\n        ' + (0, _preview2.default)(preview) + '\n        ' + content + '\n      </body>\n    </html>\n  ';
}
module.exports = exports['default'];