"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeadComponent = exports.BodyComponent = void 0;

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _lodash = require("lodash");

var _mjmlParserXml = _interopRequireDefault(require("mjml-parser-xml"));

var _shorthandParser = _interopRequireWildcard(require("./helpers/shorthandParser"));

var _formatAttributes = _interopRequireDefault(require("./helpers/formatAttributes"));

var _jsonToXML = _interopRequireDefault(require("./helpers/jsonToXML"));

var _components = _interopRequireWildcard(require("./components"));

var Component = /*#__PURE__*/function () {
  (0, _createClass2["default"])(Component, null, [{
    key: "getTagName",
    value: function getTagName() {
      return (0, _lodash.kebabCase)(this.name);
    }
  }, {
    key: "isRawElement",
    value: function isRawElement() {
      return !!this.rawElement;
    }
  }]);

  function Component() {
    var initialDatas = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2["default"])(this, Component);
    var _initialDatas$attribu = initialDatas.attributes,
        attributes = _initialDatas$attribu === void 0 ? {} : _initialDatas$attribu,
        _initialDatas$childre = initialDatas.children,
        children = _initialDatas$childre === void 0 ? [] : _initialDatas$childre,
        _initialDatas$content = initialDatas.content,
        content = _initialDatas$content === void 0 ? '' : _initialDatas$content,
        _initialDatas$context = initialDatas.context,
        context = _initialDatas$context === void 0 ? {} : _initialDatas$context,
        _initialDatas$props = initialDatas.props,
        props = _initialDatas$props === void 0 ? {} : _initialDatas$props,
        _initialDatas$globalA = initialDatas.globalAttributes,
        globalAttributes = _initialDatas$globalA === void 0 ? {} : _initialDatas$globalA;
    this.props = (0, _objectSpread2["default"])({}, props, {
      children: children,
      content: content
    });
    this.attributes = (0, _formatAttributes["default"])((0, _objectSpread2["default"])({}, this.constructor.defaultAttributes, {}, globalAttributes, {}, attributes), this.constructor.allowedAttributes);
    this.context = context;
    return this;
  }

  (0, _createClass2["default"])(Component, [{
    key: "getChildContext",
    value: function getChildContext() {
      return this.context;
    }
  }, {
    key: "getAttribute",
    value: function getAttribute(name) {
      return this.attributes[name];
    }
  }, {
    key: "getContent",
    value: function getContent() {
      return this.props.content.trim();
    }
  }, {
    key: "renderMJML",
    value: function renderMJML(mjml) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (typeof mjml === 'string') {
        mjml = (0, _mjmlParserXml["default"])(mjml, (0, _objectSpread2["default"])({}, options, {
          components: _components["default"],
          ignoreIncludes: true
        }));
      }

      return this.context.processing(mjml, this.context);
    }
  }]);
  return Component;
}();

(0, _defineProperty2["default"])(Component, "defaultAttributes", {});

var BodyComponent = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(BodyComponent, _Component);

  function BodyComponent() {
    (0, _classCallCheck2["default"])(this, BodyComponent);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(BodyComponent).apply(this, arguments));
  }

  (0, _createClass2["default"])(BodyComponent, [{
    key: "getStyles",
    // eslint-disable-next-line class-methods-use-this
    value: function getStyles() {
      return {};
    }
  }, {
    key: "getShorthandAttrValue",
    value: function getShorthandAttrValue(attribute, direction) {
      var mjAttributeDirection = this.getAttribute("".concat(attribute, "-").concat(direction));
      var mjAttribute = this.getAttribute(attribute);

      if (mjAttributeDirection) {
        return parseInt(mjAttributeDirection, 10);
      }

      if (!mjAttribute) {
        return 0;
      }

      return (0, _shorthandParser["default"])(mjAttribute, direction);
    }
  }, {
    key: "getShorthandBorderValue",
    value: function getShorthandBorderValue(direction) {
      var borderDirection = direction && this.getAttribute("border-".concat(direction));
      var border = this.getAttribute('border');
      return (0, _shorthandParser.borderParser)(borderDirection || border || '0', 10);
    }
  }, {
    key: "getBoxWidths",
    value: function getBoxWidths() {
      var containerWidth = this.context.containerWidth;
      var parsedWidth = parseInt(containerWidth, 10);
      var paddings = this.getShorthandAttrValue('padding', 'right') + this.getShorthandAttrValue('padding', 'left');
      var borders = this.getShorthandBorderValue('right') + this.getShorthandBorderValue('left');
      return {
        totalWidth: parsedWidth,
        borders: borders,
        paddings: paddings,
        box: parsedWidth - paddings - borders
      };
    }
  }, {
    key: "htmlAttributes",
    value: function htmlAttributes(attributes) {
      var _this = this;

      var specialAttributes = {
        style: function style(v) {
          return _this.styles(v);
        },
        "default": _lodash.identity
      };
      return (0, _lodash.reduce)(attributes, function (output, v, name) {
        var value = (specialAttributes[name] || specialAttributes["default"])(v);

        if (!(0, _lodash.isNil)(value)) {
          return "".concat(output, " ").concat(name, "=\"").concat(value, "\"");
        }

        return output;
      }, '');
    }
  }, {
    key: "styles",
    value: function styles(_styles) {
      var stylesObject;

      if (_styles) {
        if (typeof _styles === 'string') {
          stylesObject = (0, _lodash.get)(this.getStyles(), _styles);
        } else {
          stylesObject = _styles;
        }
      }

      return (0, _lodash.reduce)(stylesObject, function (output, value, name) {
        if (!(0, _lodash.isNil)(value)) {
          return "".concat(output).concat(name, ":").concat(value, ";");
        }

        return output;
      }, '');
    }
  }, {
    key: "renderChildren",
    value: function renderChildren(childrens) {
      var _this2 = this;

      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var _options$props = options.props,
          props = _options$props === void 0 ? {} : _options$props,
          _options$renderer = options.renderer,
          renderer = _options$renderer === void 0 ? function (component) {
        return component.render();
      } : _options$renderer,
          _options$attributes = options.attributes,
          attributes = _options$attributes === void 0 ? {} : _options$attributes,
          _options$rawXML = options.rawXML,
          rawXML = _options$rawXML === void 0 ? false : _options$rawXML;
      childrens = childrens || this.props.children;

      if (rawXML) {
        return childrens.map(function (child) {
          return (0, _jsonToXML["default"])(child);
        }).join('\n');
      }

      var sibling = childrens.length;
      var rawComponents = (0, _lodash.filter)(_components["default"], function (c) {
        return c.isRawElement();
      });
      var nonRawSiblings = childrens.filter(function (child) {
        return !(0, _lodash.find)(rawComponents, function (c) {
          return c.getTagName() === child.tagName;
        });
      }).length;
      var output = '';
      var index = 0;
      (0, _lodash.forEach)(childrens, function (children) {
        var component = (0, _components.initComponent)({
          name: children.tagName,
          initialDatas: (0, _objectSpread2["default"])({}, children, {
            attributes: (0, _objectSpread2["default"])({}, attributes, {}, children.attributes),
            context: _this2.getChildContext(),
            props: (0, _objectSpread2["default"])({}, props, {
              first: index === 0,
              index: index,
              last: index + 1 === sibling,
              sibling: sibling,
              nonRawSiblings: nonRawSiblings
            })
          })
        });

        if (component !== null) {
          output += renderer(component);
        }

        index++; // eslint-disable-line no-plusplus
      });
      return output;
    }
  }]);
  return BodyComponent;
}(Component);

exports.BodyComponent = BodyComponent;

var HeadComponent = /*#__PURE__*/function (_Component2) {
  (0, _inherits2["default"])(HeadComponent, _Component2);

  function HeadComponent() {
    (0, _classCallCheck2["default"])(this, HeadComponent);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(HeadComponent).apply(this, arguments));
  }

  (0, _createClass2["default"])(HeadComponent, [{
    key: "handlerChildren",
    value: function handlerChildren() {
      var _this3 = this;

      var childrens = this.props.children;
      return childrens.map(function (children) {
        var component = (0, _components.initComponent)({
          name: children.tagName,
          initialDatas: (0, _objectSpread2["default"])({}, children, {
            context: _this3.getChildContext()
          })
        });

        if (!component) {
          // eslint-disable-next-line no-console
          console.error("No matching component for tag : ".concat(children.tagName));
          return null;
        }

        if (component.handler) {
          component.handler();
        }

        if (component.render) {
          return component.render();
        }

        return null;
      });
    }
  }], [{
    key: "getTagName",
    value: function getTagName() {
      return (0, _lodash.kebabCase)(this.name);
    }
  }]);
  return HeadComponent;
}(Component);

exports.HeadComponent = HeadComponent;