"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = conditionalTag;
exports.msoConditionalTag = msoConditionalTag;
exports.endNegationConditionalTag = exports.startMsoNegationConditionalTag = exports.startNegationConditionalTag = exports.endConditionalTag = exports.startMsoConditionalTag = exports.startConditionalTag = void 0;
var startConditionalTag = '<!--[if mso | IE]>';
exports.startConditionalTag = startConditionalTag;
var startMsoConditionalTag = '<!--[if mso]>';
exports.startMsoConditionalTag = startMsoConditionalTag;
var endConditionalTag = '<![endif]-->';
exports.endConditionalTag = endConditionalTag;
var startNegationConditionalTag = '<!--[if !mso | IE]><!-->';
exports.startNegationConditionalTag = startNegationConditionalTag;
var startMsoNegationConditionalTag = '<!--[if !mso><!-->';
exports.startMsoNegationConditionalTag = startMsoNegationConditionalTag;
var endNegationConditionalTag = '<!--<![endif]-->';
exports.endNegationConditionalTag = endNegationConditionalTag;

function conditionalTag(content) {
  var negation = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return "\n    ".concat(negation ? startNegationConditionalTag : startConditionalTag, "\n    ").concat(content, "\n    ").concat(negation ? endNegationConditionalTag : endConditionalTag, "\n  ");
}

function msoConditionalTag(content) {
  var negation = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return "\n    ".concat(negation ? startMsoNegationConditionalTag : startMsoConditionalTag, "\n    ").concat(content, "\n    ").concat(negation ? endNegationConditionalTag : endConditionalTag, "\n  ");
}