"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildFontsTags = buildFontsTags;

var _forEach = _interopRequireDefault(require("lodash/forEach"));

var _map = _interopRequireDefault(require("lodash/map"));

// eslint-disable-next-line import/prefer-default-export
function buildFontsTags(content, inlineStyle) {
  var fonts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var toImport = [];
  (0, _forEach["default"])(fonts, function (url, name) {
    var regex = new RegExp("\"[^\"]*font-family:[^\"]*".concat(name, "[^\"]*\""), 'gmi');
    var inlineRegex = new RegExp("font-family:[^;}]*".concat(name), 'gmi');

    if (content.match(regex) || inlineStyle.some(function (s) {
      return s.match(inlineRegex);
    })) {
      toImport.push(url);
    }
  });

  if (toImport.length > 0) {
    return "\n      <!--[if !mso]><!-->\n        ".concat((0, _map["default"])(toImport, function (url) {
      return "<link href=\"".concat(url, "\" rel=\"stylesheet\" type=\"text/css\">");
    }).join('\n'), "\n        <style type=\"text/css\">\n          ").concat((0, _map["default"])(toImport, function (url) {
      return "@import url(".concat(url, ");");
    }).join('\n'), "\n        </style>\n      <!--<![endif]-->\n\n    ");
  }

  return '';
}