"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var jsonToXML = function jsonToXML(_ref) {
  var tagName = _ref.tagName,
      attributes = _ref.attributes,
      children = _ref.children,
      content = _ref.content;
  var subNode = children && children.length > 0 ? children.map(jsonToXML).join('\n') : content || '';
  var stringAttrs = Object.keys(attributes).map(function (attr) {
    return "".concat(attr, "=\"").concat(attributes[attr], "\"");
  }).join(' ');
  return "<".concat(tagName).concat(stringAttrs === '' ? '>' : " ".concat(stringAttrs, ">")).concat(subNode, "</").concat(tagName, ">");
};

var _default = jsonToXML;
exports["default"] = _default;
module.exports = exports.default;