"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = mjml2html;
Object.defineProperty(exports, "components", {
  enumerable: true,
  get: function get() {
    return _components["default"];
  }
});
Object.defineProperty(exports, "initComponent", {
  enumerable: true,
  get: function get() {
    return _components.initComponent;
  }
});
Object.defineProperty(exports, "registerComponent", {
  enumerable: true,
  get: function get() {
    return _components.registerComponent;
  }
});
Object.defineProperty(exports, "suffixCssClasses", {
  enumerable: true,
  get: function get() {
    return _suffixCssClasses["default"];
  }
});
Object.defineProperty(exports, "initializeType", {
  enumerable: true,
  get: function get() {
    return _type.initializeType;
  }
});
Object.defineProperty(exports, "handleMjmlConfig", {
  enumerable: true,
  get: function get() {
    return _mjmlconfig["default"];
  }
});
Object.defineProperty(exports, "BodyComponent", {
  enumerable: true,
  get: function get() {
    return _createComponent.BodyComponent;
  }
});
Object.defineProperty(exports, "HeadComponent", {
  enumerable: true,
  get: function get() {
    return _createComponent.HeadComponent;
  }
});

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _wrapNativeSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/wrapNativeSuper"));

var _lodash = require("lodash");

var _path = _interopRequireDefault(require("path"));

var _juice = _interopRequireDefault(require("juice"));

var _jsBeautify = require("js-beautify");

var _htmlMinifier = require("html-minifier");

var _mjmlParserXml = _interopRequireDefault(require("mjml-parser-xml"));

var _mjmlValidator = _interopRequireDefault(require("mjml-validator"));

var _mjmlMigrate = require("mjml-migrate");

var _components = _interopRequireWildcard(require("./components"));

var _suffixCssClasses = _interopRequireDefault(require("./helpers/suffixCssClasses"));

var _mergeOutlookConditionnals = _interopRequireDefault(require("./helpers/mergeOutlookConditionnals"));

var _minifyOutlookConditionnals = _interopRequireDefault(require("./helpers/minifyOutlookConditionnals"));

var _skeleton = _interopRequireDefault(require("./helpers/skeleton"));

var _type = require("./types/type");

var _mjmlconfig = _interopRequireWildcard(require("./helpers/mjmlconfig"));

var _createComponent = require("./createComponent");

var ValidationError = /*#__PURE__*/function (_Error) {
  (0, _inherits2["default"])(ValidationError, _Error);

  function ValidationError(message, errors) {
    var _this;

    (0, _classCallCheck2["default"])(this, ValidationError);
    _this = (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(ValidationError).call(this, message));
    _this.errors = errors;
    return _this;
  }

  return ValidationError;
}( /*#__PURE__*/(0, _wrapNativeSuper2["default"])(Error));

function mjml2html(mjml) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var content = '';
  var errors = [];

  if (typeof options.skeleton === 'string') {
    /* eslint-disable global-require */

    /* eslint-disable import/no-dynamic-require */
    options.skeleton = require(options.skeleton.charAt(0) === '.' ? _path["default"].resolve(process.cwd(), options.skeleton) : options.skeleton);
    /* eslint-enable global-require */

    /* eslint-enable import/no-dynamic-require */
  }

  var packages = {};
  var confOptions = {};
  var mjmlConfigOptions = {};
  var error = null;
  var componentRootPath = null;

  if (options.useMjmlConfigOptions || options.mjmlConfigPath) {
    var mjmlConfigContent = (0, _mjmlconfig.readMjmlConfig)(options.mjmlConfigPath);
    var _mjmlConfigContent$mj = mjmlConfigContent.mjmlConfig;
    packages = _mjmlConfigContent$mj.packages;
    confOptions = _mjmlConfigContent$mj.options;
    componentRootPath = mjmlConfigContent.componentRootPath;
    error = mjmlConfigContent.error;

    if (options.useMjmlConfigOptions) {
      mjmlConfigOptions = confOptions;
    }
  } // if mjmlConfigPath is specified then we need to register components it on each call


  if (!error && options.mjmlConfigPath) {
    (0, _mjmlconfig.handleMjmlConfigComponents)(packages, componentRootPath, _components.registerComponent);
  }

  var _mjmlConfigOptions$op = (0, _objectSpread2["default"])({}, mjmlConfigOptions, {}, options),
      _mjmlConfigOptions$op2 = _mjmlConfigOptions$op.beautify,
      beautify = _mjmlConfigOptions$op2 === void 0 ? false : _mjmlConfigOptions$op2,
      _mjmlConfigOptions$op3 = _mjmlConfigOptions$op.fonts,
      fonts = _mjmlConfigOptions$op3 === void 0 ? {
    'Open Sans': 'https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,700',
    'Droid Sans': 'https://fonts.googleapis.com/css?family=Droid+Sans:300,400,500,700',
    Lato: 'https://fonts.googleapis.com/css?family=Lato:300,400,500,700',
    Roboto: 'https://fonts.googleapis.com/css?family=Roboto:300,400,500,700',
    Ubuntu: 'https://fonts.googleapis.com/css?family=Ubuntu:300,400,500,700'
  } : _mjmlConfigOptions$op3,
      keepComments = _mjmlConfigOptions$op.keepComments,
      _mjmlConfigOptions$op4 = _mjmlConfigOptions$op.minify,
      minify = _mjmlConfigOptions$op4 === void 0 ? false : _mjmlConfigOptions$op4,
      _mjmlConfigOptions$op5 = _mjmlConfigOptions$op.minifyOptions,
      minifyOptions = _mjmlConfigOptions$op5 === void 0 ? {} : _mjmlConfigOptions$op5,
      _mjmlConfigOptions$op6 = _mjmlConfigOptions$op.ignoreIncludes,
      ignoreIncludes = _mjmlConfigOptions$op6 === void 0 ? false : _mjmlConfigOptions$op6,
      _mjmlConfigOptions$op7 = _mjmlConfigOptions$op.juiceOptions,
      juiceOptions = _mjmlConfigOptions$op7 === void 0 ? {} : _mjmlConfigOptions$op7,
      _mjmlConfigOptions$op8 = _mjmlConfigOptions$op.juicePreserveTags,
      juicePreserveTags = _mjmlConfigOptions$op8 === void 0 ? null : _mjmlConfigOptions$op8,
      _mjmlConfigOptions$op9 = _mjmlConfigOptions$op.skeleton,
      skeleton = _mjmlConfigOptions$op9 === void 0 ? _skeleton["default"] : _mjmlConfigOptions$op9,
      _mjmlConfigOptions$op10 = _mjmlConfigOptions$op.validationLevel,
      validationLevel = _mjmlConfigOptions$op10 === void 0 ? 'soft' : _mjmlConfigOptions$op10,
      _mjmlConfigOptions$op11 = _mjmlConfigOptions$op.filePath,
      filePath = _mjmlConfigOptions$op11 === void 0 ? '.' : _mjmlConfigOptions$op11,
      _mjmlConfigOptions$op12 = _mjmlConfigOptions$op.actualPath,
      actualPath = _mjmlConfigOptions$op12 === void 0 ? '.' : _mjmlConfigOptions$op12,
      _mjmlConfigOptions$op13 = _mjmlConfigOptions$op.noMigrateWarn,
      noMigrateWarn = _mjmlConfigOptions$op13 === void 0 ? false : _mjmlConfigOptions$op13,
      preprocessors = _mjmlConfigOptions$op.preprocessors;

  if (typeof mjml === 'string') {
    mjml = (0, _mjmlParserXml["default"])(mjml, {
      keepComments: keepComments,
      components: _components["default"],
      filePath: filePath,
      actualPath: actualPath,
      preprocessors: preprocessors,
      ignoreIncludes: ignoreIncludes
    });
  }

  mjml = (0, _mjmlMigrate.handleMjml3)(mjml, {
    noMigrateWarn: noMigrateWarn
  });
  var globalDatas = {
    backgroundColor: '',
    breakpoint: '480px',
    classes: {},
    classesDefault: {},
    defaultAttributes: {},
    fonts: fonts,
    inlineStyle: [],
    headStyle: {},
    componentsHeadStyle: [],
    headRaw: [],
    mediaQueries: {},
    preview: '',
    style: [],
    title: '',
    forceOWADesktop: (0, _lodash.get)(mjml, 'attributes.owa', 'mobile') === 'desktop',
    lang: (0, _lodash.get)(mjml, 'attributes.lang')
  };
  var validatorOptions = {
    components: _components["default"],
    initializeType: _type.initializeType
  };

  switch (validationLevel) {
    case 'skip':
      break;

    case 'strict':
      errors = (0, _mjmlValidator["default"])(mjml, validatorOptions);

      if (errors.length > 0) {
        throw new ValidationError("ValidationError: \n ".concat(errors.map(function (e) {
          return e.formattedMessage;
        }).join('\n')), errors);
      }

      break;

    case 'soft':
    default:
      errors = (0, _mjmlValidator["default"])(mjml, validatorOptions);
      break;
  }

  var mjBody = (0, _lodash.find)(mjml.children, {
    tagName: 'mj-body'
  });
  var mjHead = (0, _lodash.find)(mjml.children, {
    tagName: 'mj-head'
  });

  var _processing = function processing(node, context) {
    var parseMJML = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _lodash.identity;

    if (!node) {
      return;
    }

    var component = (0, _components.initComponent)({
      name: node.tagName,
      initialDatas: (0, _objectSpread2["default"])({}, parseMJML(node), {
        context: context
      })
    });

    if (component !== null) {
      if ('handler' in component) {
        return component.handler(); // eslint-disable-line consistent-return
      }

      if ('render' in component) {
        return component.render(); // eslint-disable-line consistent-return
      }
    }
  };

  var applyAttributes = function applyAttributes(mjml) {
    var parse = function parse(mjml) {
      var parentMjClass = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      var attributes = mjml.attributes,
          tagName = mjml.tagName,
          children = mjml.children;
      var classes = (0, _lodash.get)(mjml.attributes, 'mj-class', '').split(' ');
      var attributesClasses = (0, _lodash.reduce)(classes, function (acc, value) {
        var mjClassValues = globalDatas.classes[value];
        var multipleClasses = {};

        if (acc['css-class'] && (0, _lodash.get)(mjClassValues, 'css-class')) {
          multipleClasses = {
            'css-class': "".concat(acc['css-class'], " ").concat(mjClassValues['css-class'])
          };
        }

        return (0, _objectSpread2["default"])({}, acc, {}, mjClassValues, {}, multipleClasses);
      }, {});
      var defaultAttributesForClasses = (0, _lodash.reduce)(parentMjClass.split(' '), function (acc, value) {
        return (0, _objectSpread2["default"])({}, acc, {}, (0, _lodash.get)(globalDatas.classesDefault, "".concat(value, ".").concat(tagName)));
      }, {});
      var nextParentMjClass = (0, _lodash.get)(attributes, 'mj-class', parentMjClass);
      return (0, _objectSpread2["default"])({}, mjml, {
        attributes: (0, _objectSpread2["default"])({}, globalDatas.defaultAttributes[tagName], {}, attributesClasses, {}, defaultAttributesForClasses, {}, (0, _lodash.omit)(attributes, ['mj-class'])),
        globalAttributes: (0, _objectSpread2["default"])({}, globalDatas.defaultAttributes['mj-all']),
        children: (0, _lodash.map)(children, function (mjml) {
          return parse(mjml, nextParentMjClass);
        })
      });
    };

    return parse(mjml);
  };

  var bodyHelpers = {
    addMediaQuery: function addMediaQuery(className, _ref) {
      var parsedWidth = _ref.parsedWidth,
          unit = _ref.unit;
      globalDatas.mediaQueries[className] = "{ width:".concat(parsedWidth).concat(unit, " !important; max-width: ").concat(parsedWidth).concat(unit, "; }");
    },
    addHeadStyle: function addHeadStyle(identifier, headStyle) {
      globalDatas.headStyle[identifier] = headStyle;
    },
    addComponentHeadSyle: function addComponentHeadSyle(headStyle) {
      globalDatas.componentsHeadStyle.push(headStyle);
    },
    setBackgroundColor: function setBackgroundColor(color) {
      globalDatas.backgroundColor = color;
    },
    processing: function processing(node, context) {
      return _processing(node, context, applyAttributes);
    }
  };
  var headHelpers = {
    add: function add(attr) {
      for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        params[_key - 1] = arguments[_key];
      }

      if (Array.isArray(globalDatas[attr])) {
        var _globalDatas$attr;

        (_globalDatas$attr = globalDatas[attr]).push.apply(_globalDatas$attr, params);
      } else if (Object.prototype.hasOwnProperty.call(globalDatas, attr)) {
        if (params.length > 1) {
          if ((0, _lodash.isObject)(globalDatas[attr][params[0]])) {
            globalDatas[attr][params[0]] = (0, _objectSpread2["default"])({}, globalDatas[attr][params[0]], {}, params[1]);
          } else {
            globalDatas[attr][params[0]] = params[1];
          }
        } else {
          globalDatas[attr] = params[0];
        }
      } else {
        throw Error("An mj-head element add an unkown head attribute : ".concat(attr, " with params ").concat(Array.isArray(params) ? params.join('') : params));
      }
    }
  };
  globalDatas.headRaw = _processing(mjHead, headHelpers);
  content = _processing(mjBody, bodyHelpers, applyAttributes);

  if (minify && minify !== 'false') {
    content = (0, _minifyOutlookConditionnals["default"])(content);
  }

  content = skeleton((0, _objectSpread2["default"])({
    content: content
  }, globalDatas));

  if (globalDatas.inlineStyle.length > 0) {
    if (juicePreserveTags) {
      (0, _lodash.each)(juicePreserveTags, function (val, key) {
        _juice["default"].codeBlocks[key] = val;
      });
    }

    content = (0, _juice["default"])(content, (0, _objectSpread2["default"])({
      applyStyleTags: false,
      extraCss: globalDatas.inlineStyle.join(''),
      insertPreservedExtraCss: false,
      removeStyleTags: false
    }, juiceOptions));
  }

  content = beautify && beautify !== 'false' ? (0, _jsBeautify.html)(content, {
    indent_size: 2,
    wrap_attributes_indent_size: 2,
    max_preserve_newline: 0,
    preserve_newlines: false
  }) : content;

  if (minify && minify !== 'false') {
    content = (0, _htmlMinifier.minify)(content, (0, _objectSpread2["default"])({
      collapseWhitespace: true,
      minifyCSS: false,
      caseSensitive: true,
      removeEmptyAttributes: true
    }, minifyOptions));
  }

  content = (0, _mergeOutlookConditionnals["default"])(content);
  return {
    html: content,
    errors: errors
  };
}

(0, _mjmlconfig["default"])(process.cwd(), _components.registerComponent);