"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.matcher = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _type = _interopRequireDefault(require("./type"));

var _colors = _interopRequireDefault(require("./helpers/colors"));

var matcher = /^color/gim;
exports.matcher = matcher;
var shorthandRegex = /^#\w{3}$/;
var replaceInputRegex = /^#(\w)(\w)(\w)$/;
var replaceOutput = '#$1$1$2$2$3$3';

var _default = function _default() {
  return (/*#__PURE__*/function (_Type) {
      (0, _inherits2["default"])(Color, _Type);

      function Color(color) {
        var _this;

        (0, _classCallCheck2["default"])(this, Color);
        _this = (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(Color).call(this, color));
        _this.matchers = [/rgba\(\d{1,3},\s?\d{1,3},\s?\d{1,3},\s?\d(\.\d{1,3})?\)/gi, /rgb\(\d{1,3},\s?\d{1,3},\s?\d{1,3}\)/gi, /^#([0-9a-f]{3}){1,2}$/gi, new RegExp("^(".concat(_colors["default"].join('|'), ")$"))];
        return _this;
      }

      (0, _createClass2["default"])(Color, [{
        key: "getValue",
        value: function getValue() {
          if (this.value.match(shorthandRegex)) {
            return this.value.replace(replaceInputRegex, replaceOutput);
          }

          return this.value;
        }
      }]);
      return Color;
    }(_type["default"])
  );
};

exports["default"] = _default;