"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.initializeType = exports.types = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _some = _interopRequireDefault(require("lodash/some"));

var _find = _interopRequireDefault(require("lodash/find"));

var _index = _interopRequireDefault(require("./index"));

// Avoid recreate existing types
var types = {};
exports.types = types;

var initializeType = function initializeType(typeConfig) {
  if (types[typeConfig]) {
    return types[typeConfig];
  }

  var _ref = (0, _find["default"])(_index["default"], function (type) {
    return !!typeConfig.match(type.matcher);
  }) || {},
      typeConstructor = _ref.typeConstructor;

  if (!typeConstructor) {
    throw new Error("No type found for ".concat(typeConfig));
  }

  types[typeConfig] = typeConstructor(typeConfig);
  return types[typeConfig];
};

exports.initializeType = initializeType;

var Type = /*#__PURE__*/function () {
  function Type(value) {
    (0, _classCallCheck2["default"])(this, Type);
    this.value = value;
  }

  (0, _createClass2["default"])(Type, [{
    key: "isValid",
    value: function isValid() {
      var _this = this;

      return (0, _some["default"])(this.matchers, function (matcher) {
        return "".concat(_this.value).match(matcher);
      });
    }
  }, {
    key: "getErrorMessage",
    value: function getErrorMessage() {
      if (this.isValid()) {
        return;
      }

      var errorMessage = this.constructor.errorMessage || "has invalid value: ".concat(this.value, " for type ").concat(this.constructor.name, " ");
      return errorMessage.replace(/\$value/g, this.value);
    }
  }, {
    key: "getValue",
    value: function getValue() {
      return this.value;
    }
  }], [{
    key: "check",
    value: function check(type) {
      return !!type.match(this.constructor.typeChecker);
    }
  }]);
  return Type;
}();

exports["default"] = Type;