"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.matcher = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _escapeRegExp = _interopRequireDefault(require("lodash/escapeRegExp"));

var _type = _interopRequireDefault(require("./type"));

var matcher = /^(unit|unitWithNegative)\(.*\)/gim;
exports.matcher = matcher;

var _default = function _default(params) {
  var _class, _temp;

  var allowNeg = params.match(/^unitWithNegative/) ? '-|' : '';
  var units = params.match(/\(([^)]+)\)/)[1].split(',');
  var argsMatch = params.match(/\{([^}]+)\}/);
  var args = argsMatch && argsMatch[1] && argsMatch[1].split(',') || ['1']; // defaults to 1

  var allowAuto = units.includes('auto') ? '|auto' : '';
  var filteredUnits = units.filter(function (u) {
    return u !== 'auto';
  });
  return _temp = _class = /*#__PURE__*/function (_Type) {
    (0, _inherits2["default"])(Unit, _Type);

    function Unit(value) {
      var _this;

      (0, _classCallCheck2["default"])(this, Unit);
      _this = (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(Unit).call(this, value));
      _this.matchers = [new RegExp("^(((".concat(allowNeg, "\\d|,|\\.){1,}(").concat(filteredUnits.map(_escapeRegExp["default"]).join('|'), ")|0").concat(allowAuto, ")( )?){").concat(args.join(','), "}$"))];
      return _this;
    }

    return Unit;
  }(_type["default"]), (0, _defineProperty2["default"])(_class, "errorMessage", "has invalid value: $value for type Unit, only accepts (".concat(units.join(', '), ") units and ").concat(args.join(' to '), " value(s)")), _temp;
};

exports["default"] = _default;