'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _class, _temp;

var _mjmlCore = require('mjml-core');

var _widthParser5 = require('mjml-core/lib/helpers/widthParser');

var _widthParser6 = _interopRequireDefault(_widthParser5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MjGroup = (_temp = _class = function (_BodyComponent) {
  (0, _inherits3.default)(MjGroup, _BodyComponent);

  function MjGroup() {
    (0, _classCallCheck3.default)(this, MjGroup);
    return (0, _possibleConstructorReturn3.default)(this, (MjGroup.__proto__ || (0, _getPrototypeOf2.default)(MjGroup)).apply(this, arguments));
  }

  (0, _createClass3.default)(MjGroup, [{
    key: 'getChildContext',
    value: function getChildContext() {
      var parentWidth = this.context.containerWidth;
      var _props = this.props,
          nonRawSiblings = _props.nonRawSiblings,
          children = _props.children;

      var paddingSize = this.getShorthandAttrValue('padding', 'left') + this.getShorthandAttrValue('padding', 'right');

      var containerWidth = this.getAttribute('width') || parseFloat(parentWidth) / nonRawSiblings + 'px';

      var _widthParser = (0, _widthParser6.default)(containerWidth, {
        parseFloatToInt: false
      }),
          unit = _widthParser.unit,
          parsedWidth = _widthParser.parsedWidth;

      if (unit === '%') {
        containerWidth = parseFloat(parentWidth) * parsedWidth / 100 - paddingSize + 'px';
      } else {
        containerWidth = parsedWidth - paddingSize + 'px';
      }

      return (0, _extends3.default)({}, this.context, {
        containerWidth: containerWidth,
        nonRawSiblings: children.length
      });
    }
  }, {
    key: 'getStyles',
    value: function getStyles() {
      return {
        div: {
          'font-size': '0',
          'line-height': '0',
          'text-align': 'left',
          display: 'inline-block',
          width: '100%',
          direction: this.getAttribute('direction'),
          'vertical-align': this.getAttribute('vertical-align'),
          'background-color': this.getAttribute('background-color')
        },
        tdOutlook: {
          'vertical-align': this.getAttribute('vertical-align'),
          width: this.getWidthAsPixel()
        }
      };
    }
  }, {
    key: 'getParsedWidth',
    value: function getParsedWidth(toString) {
      var nonRawSiblings = this.props.nonRawSiblings;


      var width = this.getAttribute('width') || 100 / nonRawSiblings + '%';

      var _widthParser2 = (0, _widthParser6.default)(width, {
        parseFloatToInt: false
      }),
          unit = _widthParser2.unit,
          parsedWidth = _widthParser2.parsedWidth;

      if (toString) {
        return '' + parsedWidth + unit;
      }

      return {
        unit: unit,
        parsedWidth: parsedWidth
      };
    }
  }, {
    key: 'getWidthAsPixel',
    value: function getWidthAsPixel() {
      var containerWidth = this.context.containerWidth;

      var _widthParser3 = (0, _widthParser6.default)(this.getParsedWidth(true), {
        parseFloatToInt: false
      }),
          unit = _widthParser3.unit,
          parsedWidth = _widthParser3.parsedWidth;

      if (unit === '%') {
        return parseFloat(containerWidth) * parsedWidth / 100 + 'px';
      }
      return parsedWidth + 'px';
    }
  }, {
    key: 'getColumnClass',
    value: function getColumnClass() {
      var addMediaQuery = this.context.addMediaQuery;


      var className = '';

      var _getParsedWidth = this.getParsedWidth(),
          parsedWidth = _getParsedWidth.parsedWidth,
          unit = _getParsedWidth.unit;

      switch (unit) {
        case '%':
          className = 'mj-column-per-' + parseInt(parsedWidth, 10);
          break;

        case 'px':
        default:
          className = 'mj-column-px-' + parseInt(parsedWidth, 10);
          break;
      }

      // Add className to media queries
      addMediaQuery(className, {
        parsedWidth: parsedWidth,
        unit: unit
      });

      return className;
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          children = _props2.children,
          nonRawSiblings = _props2.nonRawSiblings;

      var _getChildContext = this.getChildContext(),
          groupWidth = _getChildContext.containerWidth;

      var containerWidth = this.context.containerWidth;


      var getElementWidth = function getElementWidth(width) {
        if (!width) {
          return parseInt(containerWidth, 10) / parseInt(nonRawSiblings, 10) + 'px';
        }

        var _widthParser4 = (0, _widthParser6.default)(width, {
          parseFloatToInt: false
        }),
            unit = _widthParser4.unit,
            parsedWidth = _widthParser4.parsedWidth;

        if (unit === '%') {
          return 100 * parsedWidth / groupWidth + 'px';
        }
        return '' + parsedWidth + unit;
      };

      var classesName = this.getColumnClass() + ' outlook-group-fix';

      if (this.getAttribute('css-class')) {
        classesName += ' ' + this.getAttribute('css-class');
      }

      return '\n      <div\n        ' + this.htmlAttributes({
        class: classesName,
        style: 'div'
      }) + '\n      >\n        <!--[if mso | IE]>\n        <table  role="presentation" border="0" cellpadding="0" cellspacing="0">\n          <tr>\n        <![endif]-->\n          ' + this.renderChildren(children, {
        attributes: { mobileWidth: 'mobileWidth' },
        renderer: function renderer(component) {
          return component.constructor.isRawElement() ? component.render() : '\n              <!--[if mso | IE]>\n              <td\n                ' + component.htmlAttributes({
            style: {
              align: component.getAttribute('align'),
              'vertical-align': component.getAttribute('vertical-align'),
              width: getElementWidth(component.getWidthAsPixel ? component.getWidthAsPixel() : component.getAttribute('width'))
            }
          }) + '\n              >\n              <![endif]-->\n                ' + component.render() + '\n              <!--[if mso | IE]>\n              </td>\n              <![endif]-->\n          ';
        }
      }) + '\n        <!--[if mso | IE]>\n          </tr>\n          </table>\n        <![endif]-->\n      </div>\n    ';
    }
  }]);
  return MjGroup;
}(_mjmlCore.BodyComponent), _class.allowedAttributes = {
  'background-color': 'color',
  direction: 'enum(ltr,rtl)',
  'vertical-align': 'enum(top,bottom,middle)',
  width: 'unit(px,%)'
}, _class.defaultAttributes = {
  direction: 'ltr'
}, _temp);
exports.default = MjGroup;
module.exports = exports['default'];