"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var _widthParser5 = _interopRequireDefault(require("mjml-core/lib/helpers/widthParser"));

var MjGroup = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjGroup, _BodyComponent);

  function MjGroup() {
    (0, _classCallCheck2["default"])(this, MjGroup);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjGroup).apply(this, arguments));
  }

  (0, _createClass2["default"])(MjGroup, [{
    key: "getChildContext",
    value: function getChildContext() {
      var parentWidth = this.context.containerWidth;
      var _this$props = this.props,
          nonRawSiblings = _this$props.nonRawSiblings,
          children = _this$props.children;
      var paddingSize = this.getShorthandAttrValue('padding', 'left') + this.getShorthandAttrValue('padding', 'right');
      var containerWidth = this.getAttribute('width') || "".concat(parseFloat(parentWidth) / nonRawSiblings, "px");

      var _widthParser = (0, _widthParser5["default"])(containerWidth, {
        parseFloatToInt: false
      }),
          unit = _widthParser.unit,
          parsedWidth = _widthParser.parsedWidth;

      if (unit === '%') {
        containerWidth = "".concat(parseFloat(parentWidth) * parsedWidth / 100 - paddingSize, "px");
      } else {
        containerWidth = "".concat(parsedWidth - paddingSize, "px");
      }

      return (0, _objectSpread2["default"])({}, this.context, {
        containerWidth: containerWidth,
        nonRawSiblings: children.length
      });
    }
  }, {
    key: "getStyles",
    value: function getStyles() {
      return {
        div: {
          'font-size': '0',
          'line-height': '0',
          'text-align': 'left',
          display: 'inline-block',
          width: '100%',
          direction: this.getAttribute('direction'),
          'vertical-align': this.getAttribute('vertical-align'),
          'background-color': this.getAttribute('background-color')
        },
        tdOutlook: {
          'vertical-align': this.getAttribute('vertical-align'),
          width: this.getWidthAsPixel()
        }
      };
    }
  }, {
    key: "getParsedWidth",
    value: function getParsedWidth(toString) {
      var nonRawSiblings = this.props.nonRawSiblings;
      var width = this.getAttribute('width') || "".concat(100 / nonRawSiblings, "%");

      var _widthParser2 = (0, _widthParser5["default"])(width, {
        parseFloatToInt: false
      }),
          unit = _widthParser2.unit,
          parsedWidth = _widthParser2.parsedWidth;

      if (toString) {
        return "".concat(parsedWidth).concat(unit);
      }

      return {
        unit: unit,
        parsedWidth: parsedWidth
      };
    }
  }, {
    key: "getWidthAsPixel",
    value: function getWidthAsPixel() {
      var containerWidth = this.context.containerWidth;

      var _widthParser3 = (0, _widthParser5["default"])(this.getParsedWidth(true), {
        parseFloatToInt: false
      }),
          unit = _widthParser3.unit,
          parsedWidth = _widthParser3.parsedWidth;

      if (unit === '%') {
        return "".concat(parseFloat(containerWidth) * parsedWidth / 100, "px");
      }

      return "".concat(parsedWidth, "px");
    }
  }, {
    key: "getColumnClass",
    value: function getColumnClass() {
      var addMediaQuery = this.context.addMediaQuery;
      var className = '';

      var _this$getParsedWidth = this.getParsedWidth(),
          parsedWidth = _this$getParsedWidth.parsedWidth,
          unit = _this$getParsedWidth.unit;

      switch (unit) {
        case '%':
          className = "mj-column-per-".concat(parseInt(parsedWidth, 10));
          break;

        case 'px':
        default:
          className = "mj-column-px-".concat(parseInt(parsedWidth, 10));
          break;
      } // Add className to media queries


      addMediaQuery(className, {
        parsedWidth: parsedWidth,
        unit: unit
      });
      return className;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          children = _this$props2.children,
          nonRawSiblings = _this$props2.nonRawSiblings;

      var _this$getChildContext = this.getChildContext(),
          groupWidth = _this$getChildContext.containerWidth;

      var containerWidth = this.context.containerWidth;

      var getElementWidth = function getElementWidth(width) {
        if (!width) {
          return "".concat(parseInt(containerWidth, 10) / parseInt(nonRawSiblings, 10), "px");
        }

        var _widthParser4 = (0, _widthParser5["default"])(width, {
          parseFloatToInt: false
        }),
            unit = _widthParser4.unit,
            parsedWidth = _widthParser4.parsedWidth;

        if (unit === '%') {
          return "".concat(100 * parsedWidth / groupWidth, "px");
        }

        return "".concat(parsedWidth).concat(unit);
      };

      var classesName = "".concat(this.getColumnClass(), " mj-outlook-group-fix");

      if (this.getAttribute('css-class')) {
        classesName += " ".concat(this.getAttribute('css-class'));
      }

      return "\n      <div\n        ".concat(this.htmlAttributes({
        "class": classesName,
        style: 'div'
      }), "\n      >\n        <!--[if mso | IE]>\n        <table\n          ").concat(this.htmlAttributes({
        bgcolor: this.getAttribute('background-color') === 'none' ? undefined : this.getAttribute('background-color'),
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation'
      }), "\n        >\n          <tr>\n        <![endif]-->\n          ").concat(this.renderChildren(children, {
        attributes: {
          mobileWidth: 'mobileWidth'
        },
        renderer: function renderer(component) {
          return component.constructor.isRawElement() ? component.render() : "\n              <!--[if mso | IE]>\n              <td\n                ".concat(component.htmlAttributes({
            style: {
              align: component.getAttribute('align'),
              'vertical-align': component.getAttribute('vertical-align'),
              width: getElementWidth(component.getWidthAsPixel ? component.getWidthAsPixel() : component.getAttribute('width'))
            }
          }), "\n              >\n              <![endif]-->\n                ").concat(component.render(), "\n              <!--[if mso | IE]>\n              </td>\n              <![endif]-->\n          ");
        }
      }), "\n        <!--[if mso | IE]>\n          </tr>\n          </table>\n        <![endif]-->\n      </div>\n    ");
    }
  }]);
  return MjGroup;
}(_mjmlCore.BodyComponent);

exports["default"] = MjGroup;
(0, _defineProperty2["default"])(MjGroup, "allowedAttributes", {
  'background-color': 'color',
  direction: 'enum(ltr,rtl)',
  'vertical-align': 'enum(top,bottom,middle)',
  width: 'unit(px,%)'
});
(0, _defineProperty2["default"])(MjGroup, "defaultAttributes", {
  direction: 'ltr'
});
module.exports = exports.default;