'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _class, _temp;

var _lodash = require('lodash');

var _mjmlCore = require('mjml-core');

var _widthParser2 = require('mjml-core/lib/helpers/widthParser');

var _widthParser3 = _interopRequireDefault(_widthParser2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MjImage = (_temp = _class = function (_BodyComponent) {
  (0, _inherits3.default)(MjImage, _BodyComponent);

  function MjImage() {
    (0, _classCallCheck3.default)(this, MjImage);
    return (0, _possibleConstructorReturn3.default)(this, (MjImage.__proto__ || (0, _getPrototypeOf2.default)(MjImage)).apply(this, arguments));
  }

  (0, _createClass3.default)(MjImage, [{
    key: 'getStyles',
    value: function getStyles() {
      var width = this.getContentWidth();
      var fullWidth = this.getAttribute('full-width') === 'full-width';

      var _widthParser = (0, _widthParser3.default)(width),
          parsedWidth = _widthParser.parsedWidth,
          unit = _widthParser.unit;

      return {
        img: {
          'border-radius': this.getAttribute('border-radius'),
          display: 'block',
          outline: 'none',
          'text-decoration': 'none',
          height: this.getAttribute('height'),
          'min-width': fullWidth ? '100%' : null,
          width: fullWidth ? '' + parsedWidth + unit : '100%',
          'max-width': fullWidth ? '100%' : null
        },
        imgWrapper: {
          border: this.getAttribute('border'),
          'border-radius': this.getAttribute('border-radius')
        },
        td: {
          width: fullWidth ? null : '' + parsedWidth + unit
        },
        table: {
          'min-width': fullWidth ? '100%' : null,
          'max-width': fullWidth ? '100%' : null,
          width: fullWidth ? '' + parsedWidth + unit : null,
          'border-collapse': 'collapse',
          'border-spacing': '0px'
        }
      };
    }
  }, {
    key: 'getShorthandRadiusValue',
    value: function getShorthandRadiusValue(attribute, direction) {
      var mjAttributeDirection = this.getAttribute(attribute + '-' + direction);
      var mjAttribute = this.getAttribute(attribute);

      if (mjAttributeDirection) {
        return parseInt(mjAttributeDirection, 10);
      }

      if (!mjAttribute) {
        return 0;
      }

      return radiusParser(mjAttribute, direction);
    }
  }, {
    key: 'getInsideBorderRadius',
    value: function getInsideBorderRadius() {
      var _this2 = this;

      var directions = ['top', 'right', 'bottom', 'left'];
      var radiusDirections = ['top-left', 'top-right', 'bottom-right', 'bottom-left'];

      return directions.map(function (direction, i) {
        var previousDirection = directions[(i - 1) % 4];
        return _this2.getShorthandAttrValue('border', radiusDirections[i] + '-radius') - (0, _lodash.max)([_this2.getShorthandAttrValue('border-radius', direction)]);
      });
    }

    // export function radius(cssValue, direction) {
    //   const splittedCssValue = cssValue.split(' ')
    //   let directions = {}
    //
    //   switch (splittedCssValue.length) {
    //     case 2:
    //       directions = { 'top-left': 0, 'top-right': 1, 'bottom-right': 0, 'bottom-left': 1 }
    //       break
    //
    //     case 3:
    //       directions = { 'top-left': 0, 'top-right': 1, 'bottom-right': 2, 'bottom-left': 1 }
    //       break
    //
    //     case 4:
    //       directions = { 'top-left': 0, 'top-right': 1, 'bottom-right': 2, 'bottom-left': 3 }
    //       break
    //     case 1:
    //     default:
    //       return parseInt(cssValue, 10)
    //   }
    //
    //   return parseInt(splittedCssValue[directions[direction]] || 0, 10)
    // }

  }, {
    key: 'getContentWidth',
    value: function getContentWidth() {
      var containerWidth = this.context.containerWidth;

      var width = this.getAttribute('width') || Infinity;

      var paddingRight = this.getShorthandAttrValue('padding', 'right');
      var paddingLeft = this.getShorthandAttrValue('padding', 'left');
      var borderRight = this.getShorthandBorderValue('right');
      var borderLeft = this.getShorthandBorderValue('left');
      var allPaddings = paddingLeft + paddingRight + borderLeft + borderRight;

      console.log('borderRight ------------------------------------------>');
      console.log(borderRight);
      console.log(borderLeft);

      return (0, _lodash.min)([containerWidth - allPaddings, width + allPaddings]);
    }
  }, {
    key: 'renderImage',
    value: function renderImage() {
      var height = this.getAttribute('height');

      var img = '\n    <div\n      ' + this.htmlAttributes({
        style: 'imgWrapper'
      }) + '\n    >\n      <img\n        ' + this.htmlAttributes({
        alt: this.getAttribute('alt'),
        height: height && (height === 'auto' ? height : parseInt(height, 10)),
        src: this.getAttribute('src'),
        srcset: this.getAttribute('srcset'),
        style: 'img',
        title: this.getAttribute('title'),
        width: this.getContentWidth()
      }) + '\n      />\n    </div>\n    ';

      if (this.getAttribute('href')) {
        return '\n        <a\n          ' + this.htmlAttributes({
          href: this.getAttribute('href'),
          target: this.getAttribute('target')
        }) + '\n        >\n          ' + img + '\n        </a>\n      ';
      }

      return img;
    }
  }, {
    key: 'render',
    value: function render() {
      return '\n      <table\n        ' + this.htmlAttributes({
        align: this.getAttribute('align'),
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        style: 'table'
      }) + '\n      >\n        <tbody>\n          <tr>\n            <td ' + this.htmlAttributes({ style: 'td' }) + '>\n              ' + this.renderImage() + '\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    ';
    }
  }]);
  return MjImage;
}(_mjmlCore.BodyComponent), _class.tagOmission = true, _class.allowedAttributes = {
  alt: 'string',
  href: 'string',
  src: 'string',
  srcset: 'string',
  title: 'string',
  align: 'enum(left,center,right)',
  border: 'string',
  'border-bottom': 'string',
  'border-left': 'string',
  'border-right': 'string',
  'border-top': 'string',
  'border-radius': 'unit(px,%)',
  'container-background-color': 'string',
  padding: 'unit(px,%){1,4}',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  height: 'unit(px)',
  width: 'unit(px)'
}, _class.defaultAttributes = {
  align: 'center',
  border: '0',
  height: 'auto',
  padding: '10px 25px',
  target: '_blank'
}, _temp);
exports.default = MjImage;
module.exports = exports['default'];