"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _min = _interopRequireDefault(require("lodash/min"));

var _mjmlCore = require("mjml-core");

var _widthParser2 = _interopRequireDefault(require("mjml-core/lib/helpers/widthParser"));

var MjImage = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjImage, _BodyComponent);

  function MjImage() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2["default"])(this, MjImage);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2["default"])(this, (_getPrototypeOf2 = (0, _getPrototypeOf3["default"])(MjImage)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "headStyle", function (breakpoint) {
      return "\n    @media only screen and (max-width:".concat(breakpoint, ") {\n      table.mj-full-width-mobile { width: 100% !important; }\n      td.mj-full-width-mobile { width: auto !important; }\n    }\n  ");
    });
    return _this;
  }

  (0, _createClass2["default"])(MjImage, [{
    key: "getStyles",
    value: function getStyles() {
      var width = this.getContentWidth();
      var fullWidth = this.getAttribute('full-width') === 'full-width';

      var _widthParser = (0, _widthParser2["default"])(width),
          parsedWidth = _widthParser.parsedWidth,
          unit = _widthParser.unit;

      return {
        img: {
          border: this.getAttribute('border'),
          'border-left': this.getAttribute('left'),
          'border-right': this.getAttribute('right'),
          'border-top': this.getAttribute('top'),
          'border-bottom': this.getAttribute('bottom'),
          'border-radius': this.getAttribute('border-radius'),
          display: 'block',
          outline: 'none',
          'text-decoration': 'none',
          height: this.getAttribute('height'),
          'max-height': this.getAttribute('max-height'),
          'min-width': fullWidth ? '100%' : null,
          width: '100%',
          'max-width': fullWidth ? '100%' : null,
          'font-size': this.getAttribute('font-size')
        },
        td: {
          width: fullWidth ? null : "".concat(parsedWidth).concat(unit)
        },
        table: {
          'min-width': fullWidth ? '100%' : null,
          'max-width': fullWidth ? '100%' : null,
          width: fullWidth ? "".concat(parsedWidth).concat(unit) : null,
          'border-collapse': 'collapse',
          'border-spacing': '0px'
        }
      };
    }
  }, {
    key: "getContentWidth",
    value: function getContentWidth() {
      var width = this.getAttribute('width') ? parseInt(this.getAttribute('width'), 10) : Infinity;

      var _this$getBoxWidths = this.getBoxWidths(),
          box = _this$getBoxWidths.box;

      return (0, _min["default"])([box, width]);
    }
  }, {
    key: "renderImage",
    value: function renderImage() {
      var height = this.getAttribute('height');
      var img = "\n      <img\n        ".concat(this.htmlAttributes({
        alt: this.getAttribute('alt'),
        height: height && (height === 'auto' ? height : parseInt(height, 10)),
        src: this.getAttribute('src'),
        srcset: this.getAttribute('srcset'),
        style: 'img',
        title: this.getAttribute('title'),
        width: this.getContentWidth(),
        usemap: this.getAttribute('usemap')
      }), "\n      />\n    ");

      if (this.getAttribute('href')) {
        return "\n        <a\n          ".concat(this.htmlAttributes({
          href: this.getAttribute('href'),
          target: this.getAttribute('target'),
          rel: this.getAttribute('rel'),
          name: this.getAttribute('name')
        }), "\n        >\n          ").concat(img, "\n        </a>\n      ");
      }

      return img;
    }
  }, {
    key: "render",
    value: function render() {
      return "\n      <table\n        ".concat(this.htmlAttributes({
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        style: 'table',
        "class": this.getAttribute('fluid-on-mobile') ? 'mj-full-width-mobile' : null
      }), "\n      >\n        <tbody>\n          <tr>\n            <td ").concat(this.htmlAttributes({
        style: 'td',
        "class": this.getAttribute('fluid-on-mobile') ? 'mj-full-width-mobile' : null
      }), ">\n              ").concat(this.renderImage(), "\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    ");
    }
  }]);
  return MjImage;
}(_mjmlCore.BodyComponent);

exports["default"] = MjImage;
(0, _defineProperty2["default"])(MjImage, "tagOmission", true);
(0, _defineProperty2["default"])(MjImage, "allowedAttributes", {
  alt: 'string',
  href: 'string',
  name: 'string',
  src: 'string',
  srcset: 'string',
  title: 'string',
  rel: 'string',
  align: 'enum(left,center,right)',
  border: 'string',
  'border-bottom': 'string',
  'border-left': 'string',
  'border-right': 'string',
  'border-top': 'string',
  'border-radius': 'unit(px,%){1,4}',
  'container-background-color': 'color',
  'fluid-on-mobile': 'boolean',
  padding: 'unit(px,%){1,4}',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  target: 'string',
  width: 'unit(px)',
  height: 'unit(px,auto)',
  'max-height': 'unit(px,%)',
  'font-size': 'unit(px)',
  usemap: 'string'
});
(0, _defineProperty2["default"])(MjImage, "defaultAttributes", {
  align: 'center',
  border: '0',
  height: 'auto',
  padding: '10px 25px',
  target: '_blank',
  'font-size': '13px'
});
module.exports = exports.default;