#!/bin/env node
'use strict';

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _commander = require('commander');

var _commander2 = _interopRequireDefault(_commander);

var _migrate = require('./migrate');

var _migrate2 = _interopRequireDefault(_migrate);

var _package = require('../package.json');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_commander2.default.version(_package.version).usage('[options] <input-file> <output-file>').parse(process.argv);

if (_commander2.default.args.length !== 2) {
  _commander2.default.outputHelp();
  process.exit(1);
}

var _program$args = (0, _slicedToArray3.default)(_commander2.default.args, 2),
    inputFilename = _program$args[0],
    outputFilename = _program$args[1];

var input = _fs2.default.readFileSync(inputFilename, 'utf8');
var output = (0, _migrate2.default)(input);

_fs2.default.writeFileSync(outputFilename, output);

// eslint-disable-next-line no-console
console.log(inputFilename + ' was converted to the MJML 4 syntax in ' + outputFilename);