#!/bin/env node
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _fs = _interopRequireDefault(require("fs"));

var _commander = _interopRequireDefault(require("commander"));

var _migrate = _interopRequireDefault(require("./migrate"));

var _package = require("../package.json");

_commander["default"].version(_package.version).usage('[options] <input-file> <output-file>').parse(process.argv);

if (_commander["default"].args.length !== 2) {
  _commander["default"].outputHelp();

  process.exit(1);
}

var _program$args = (0, _slicedToArray2["default"])(_commander["default"].args, 2),
    inputFilename = _program$args[0],
    outputFilename = _program$args[1];

var input = _fs["default"].readFileSync(inputFilename, 'utf8');

var output = (0, _migrate["default"])(input);

_fs["default"].writeFileSync(outputFilename, output); // eslint-disable-next-line no-console


console.log("".concat(inputFilename, " was converted to the MJML 4 syntax in ").concat(outputFilename));