'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _class, _temp2;

var _mjmlCore = require('mjml-core');

var _crypto = require('crypto');

var _crypto2 = _interopRequireDefault(_crypto);

var _conditionalTag = require('mjml-core/lib/helpers/conditionalTag');

var _conditionalTag2 = _interopRequireDefault(_conditionalTag);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MjNavbar = (_temp2 = _class = function (_BodyComponent) {
  (0, _inherits3.default)(MjNavbar, _BodyComponent);

  function MjNavbar() {
    var _ref;

    var _temp, _this, _ret;

    (0, _classCallCheck3.default)(this, MjNavbar);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = MjNavbar.__proto__ || (0, _getPrototypeOf2.default)(MjNavbar)).call.apply(_ref, [this].concat(args))), _this), _this.headStyle = function (breakpoint) {
      return '\n      noinput.mj-menu-checkbox { display:block!important; max-height:none!important; visibility:visible!important; }\n\n      @media only screen and (max-width:' + breakpoint + ') {\n        .mj-menu-checkbox[type="checkbox"] ~ .mj-inline-links { display:none!important; }\n        .mj-menu-checkbox[type="checkbox"]:checked ~ .mj-inline-links,\n        .mj-menu-checkbox[type="checkbox"] ~ .mj-menu-trigger { display:block!important; max-width:none!important; max-height:none!important; font-size:inherit!important; }\n        .mj-menu-checkbox[type="checkbox"] ~ .mj-inline-links > a { display:block!important; }\n        .mj-menu-checkbox[type="checkbox"]:checked ~ .mj-menu-trigger .mj-menu-icon-close { display:block!important; }\n        .mj-menu-checkbox[type="checkbox"]:checked ~ .mj-menu-trigger .mj-menu-icon-open { display:none!important; }\n      }\n    ';
    }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
  }

  (0, _createClass3.default)(MjNavbar, [{
    key: 'getStyles',
    value: function getStyles() {
      return {
        div: {
          align: this.getAttribute('align'),
          width: '100%'
        },
        label: {
          display: 'block',
          cursor: 'pointer',
          'mso-hide': 'all',
          '-moz-user-select': 'none',
          'user-select': 'none',
          align: this.getAttribute('ico-align'),
          color: this.getAttribute('ico-color'),
          'font-size': this.getAttribute('ico-font-size'),
          'font-family': this.getAttribute('ico-font-family'),
          'text-transform': this.getAttribute('ico-text-transform'),
          'text-decoration': this.getAttribute('ico-text-decoration'),
          'line-height': this.getAttribute('ico-line-height'),
          'padding-top': this.getAttribute('ico-padding-top'),
          'padding-right': this.getAttribute('ico-padding-right'),
          'padding-bottom': this.getAttribute('ico-padding-bottom'),
          'padding-left': this.getAttribute('ico-padding-left'),
          padding: this.getAttribute('ico-padding')
        },
        trigger: {
          display: 'none',
          'max-height': '0px',
          'max-width': '0px',
          'font-size': '0px',
          overflow: 'hidden'
        },
        icoOpen: {
          'mso-hide': 'all'
        },
        icoClose: {
          display: 'none',
          'mso-hide': 'all'
        }
      };
    }
  }, {
    key: 'renderHamburger',
    value: function renderHamburger() {
      var key = _crypto2.default.randomBytes(8).toString('hex');

      return '\n      ' + (0, _conditionalTag.msoConditionalTag)('\n        <input type="checkbox" id="' + key + '" class="mj-menu-checkbox" style="display:none !important; max-height:0; visibility:hidden;" />\n      ', true) + '\n      <div\n        ' + this.htmlAttributes({
        class: 'mj-menu-trigger',
        style: 'trigger'
      }) + '\n      >\n        <label\n          ' + this.htmlAttributes({
        for: key,
        class: 'mj-menu-label',
        style: 'label'
      }) + '\n        >\n          <span\n            ' + this.htmlAttributes({
        class: 'mj-menu-icon-open',
        style: 'icoOpen'
      }) + '\n          >\n            ' + this.getAttribute('ico-open') + '\n          </span>\n          <span\n            ' + this.htmlAttributes({
        class: 'mj-menu-icon-close',
        style: 'icoClose'
      }) + '\n          >\n            ' + this.getAttribute('ico-close') + '\n          </span>\n        </label>\n      </div>\n    ';
    }
  }, {
    key: 'render',
    value: function render() {
      return '\n        ' + (this.getAttribute('hamburger') === 'hamburger' ? this.renderHamburger() : '') + '\n        <div\n          ' + this.htmlAttributes({
        class: 'mj-inline-links',
        style: this.htmlAttributes('div')
      }) + '\n        >\n        ' + (0, _conditionalTag2.default)('\n          <table role="presentation" border="0" cellpadding="0" cellspacing="0" align="' + this.getAttribute('align') + '">\n            <tr>\n        ') + '\n          ' + this.renderChildren(this.props.children, {
        attributes: {
          navbarBaseUrl: this.getAttribute('base-url')
        }
      }) + '\n          ' + (0, _conditionalTag2.default)('\n            </tr></table>\n          ') + '\n        </div>\n    ';
    }
  }]);
  return MjNavbar;
}(_mjmlCore.BodyComponent), _class.allowedAttributes = {
  align: 'enum(left,center,right)',
  'base-url': 'string',
  hamburger: 'string',
  'ico-align': 'enum(left,center,right)',
  'ico-open': 'string',
  'ico-close': 'string',
  'ico-color': 'color',
  'ico-font-size': 'unit(px,%)',
  'ico-font-family': 'string',
  'ico-text-transform': 'string',
  'ico-padding': 'unit(px,%){1,4}',
  'ico-padding-left': 'unit(px,%)',
  'ico-padding-top': 'unit(px,%)',
  'ico-padding-right': 'unit(px,%)',
  'ico-padding-bottom': 'unit(px,%)',
  'ico-text-decoration': 'string',
  'ico-line-height': 'unit(px,%)'
}, _class.defaultAttributes = {
  align: 'center',
  'base-url': null,
  hamburger: null,
  'ico-align': 'center',
  'ico-open': '&#9776;',
  'ico-close': '&#8855;',
  'ico-color': '#000000',
  'ico-font-size': '30px',
  'ico-font-family': 'Ubuntu, Helvetica, Arial, sans-serif',
  'ico-text-transform': 'uppercase',
  'ico-padding': '10px',
  'ico-text-decoration': 'none',
  'ico-line-height': '30px'
}, _temp2);
exports.default = MjNavbar;
module.exports = exports['default'];