'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _class, _temp;

var _mjmlCore = require('mjml-core');

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _conditionalTag = require('mjml-core/lib/helpers/conditionalTag');

var _conditionalTag2 = _interopRequireDefault(_conditionalTag);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MjNavbarLink = (_temp = _class = function (_BodyComponent) {
  (0, _inherits3.default)(MjNavbarLink, _BodyComponent);

  function MjNavbarLink() {
    (0, _classCallCheck3.default)(this, MjNavbarLink);
    return (0, _possibleConstructorReturn3.default)(this, (MjNavbarLink.__proto__ || (0, _getPrototypeOf2.default)(MjNavbarLink)).apply(this, arguments));
  }

  (0, _createClass3.default)(MjNavbarLink, [{
    key: 'getStyles',
    value: function getStyles() {
      return {
        a: {
          display: 'inline-block',
          color: this.getAttribute('color'),
          'font-family': this.getAttribute('font-family'),
          'font-size': this.getAttribute('font-size'),
          'font-weight': this.getAttribute('font-weight'),
          'line-height': this.getAttribute('line-height'),
          'text-decoration': this.getAttribute('text-decoration'),
          'text-transform': this.getAttribute('text-transform'),
          padding: this.getAttribute('padding'),
          'padding-top': this.getAttribute('padding-top'),
          'padding-left': this.getAttribute('padding-left'),
          'padding-right': this.getAttribute('padding-right'),
          'padding-bottom': this.getAttribute('padding-bottom')
        },
        td: {
          padding: this.getAttribute('padding'),
          'padding-top': this.getAttribute('padding-top'),
          'padding-left': this.getAttribute('padding-left'),
          'padding-right': this.getAttribute('padding-right'),
          'padding-bottom': this.getAttribute('padding-bottom')
        }
      };
    }
  }, {
    key: 'renderContent',
    value: function renderContent() {
      var href = this.getAttribute('href');
      var navbarBaseUrl = this.getAttribute('navbarBaseUrl');
      var link = navbarBaseUrl ? _url2.default.resolve(navbarBaseUrl, href) : href;

      var cssClass = this.getAttribute('css-class') ? ' ' + this.getAttribute('css-class') : '';

      return '\n      <a\n        ' + this.htmlAttributes({
        class: 'mj-link' + cssClass,
        href: link,
        rel: this.getAttribute('rel'),
        target: this.getAttribute('target'),
        name: this.getAttribute('name'),
        style: 'a'
      }) + '\n      >\n        ' + this.getContent() + '\n      </a>\n    ';
    }
  }, {
    key: 'render',
    value: function render() {
      return '\n        ' + (0, _conditionalTag2.default)('\n          <td\n            ' + this.htmlAttributes({
        style: 'td',
        class: (0, _mjmlCore.suffixCssClasses)(this.getAttribute('css-class'), 'outlook')
      }) + '\n          >\n        ') + '\n        ' + this.renderContent() + '\n        ' + (0, _conditionalTag2.default)('\n          </td>\n        ') + '\n      ';
    }
  }]);
  return MjNavbarLink;
}(_mjmlCore.BodyComponent), _class.endingTag = true, _class.allowedAttributes = {
  color: 'color',
  'font-family': 'string',
  'font-size': 'unit(px)',
  'font-weight': 'string',
  href: 'string',
  name: 'string',
  target: 'string',
  rel: 'string',
  'line-height': 'unit(px,%,)',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  padding: 'unit(px,%){1,4}',
  'text-decoration': 'string',
  'text-transform': 'string'
}, _class.defaultAttributes = {
  color: '#000000',
  'font-family': 'Ubuntu, Helvetica, Arial, sans-serif',
  'font-size': '13px',
  'font-weight': 'normal',
  'line-height': '22px',
  padding: '15px 10px',
  target: '_blank',
  'text-decoration': 'none',
  'text-transform': 'uppercase'
}, _temp);
exports.default = MjNavbarLink;
module.exports = exports['default'];