"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var _crypto = _interopRequireDefault(require("crypto"));

var _conditionalTag = _interopRequireWildcard(require("mjml-core/lib/helpers/conditionalTag"));

var MjNavbar = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjNavbar, _BodyComponent);

  function MjNavbar() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2["default"])(this, MjNavbar);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2["default"])(this, (_getPrototypeOf2 = (0, _getPrototypeOf3["default"])(MjNavbar)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "headStyle", function (breakpoint) {
      return "\n      noinput.mj-menu-checkbox { display:block!important; max-height:none!important; visibility:visible!important; }\n\n      @media only screen and (max-width:".concat(breakpoint, ") {\n        .mj-menu-checkbox[type=\"checkbox\"] ~ .mj-inline-links { display:none!important; }\n        .mj-menu-checkbox[type=\"checkbox\"]:checked ~ .mj-inline-links,\n        .mj-menu-checkbox[type=\"checkbox\"] ~ .mj-menu-trigger { display:block!important; max-width:none!important; max-height:none!important; font-size:inherit!important; }\n        .mj-menu-checkbox[type=\"checkbox\"] ~ .mj-inline-links > a { display:block!important; }\n        .mj-menu-checkbox[type=\"checkbox\"]:checked ~ .mj-menu-trigger .mj-menu-icon-close { display:block!important; }\n        .mj-menu-checkbox[type=\"checkbox\"]:checked ~ .mj-menu-trigger .mj-menu-icon-open { display:none!important; }\n      }\n    ");
    });
    return _this;
  }

  (0, _createClass2["default"])(MjNavbar, [{
    key: "getStyles",
    value: function getStyles() {
      return {
        div: {
          align: this.getAttribute('align'),
          width: '100%'
        },
        label: {
          display: 'block',
          cursor: 'pointer',
          'mso-hide': 'all',
          '-moz-user-select': 'none',
          'user-select': 'none',
          color: this.getAttribute('ico-color'),
          'font-size': this.getAttribute('ico-font-size'),
          'font-family': this.getAttribute('ico-font-family'),
          'text-transform': this.getAttribute('ico-text-transform'),
          'text-decoration': this.getAttribute('ico-text-decoration'),
          'line-height': this.getAttribute('ico-line-height'),
          'padding-top': this.getAttribute('ico-padding-top'),
          'padding-right': this.getAttribute('ico-padding-right'),
          'padding-bottom': this.getAttribute('ico-padding-bottom'),
          'padding-left': this.getAttribute('ico-padding-left'),
          padding: this.getAttribute('ico-padding')
        },
        trigger: {
          display: 'none',
          'max-height': '0px',
          'max-width': '0px',
          'font-size': '0px',
          overflow: 'hidden'
        },
        icoOpen: {
          'mso-hide': 'all'
        },
        icoClose: {
          display: 'none',
          'mso-hide': 'all'
        }
      };
    }
  }, {
    key: "renderHamburger",
    value: function renderHamburger() {
      var key = _crypto["default"].randomBytes(8).toString('hex');

      return "\n      ".concat((0, _conditionalTag.msoConditionalTag)("\n        <input type=\"checkbox\" id=\"".concat(key, "\" class=\"mj-menu-checkbox\" style=\"display:none !important; max-height:0; visibility:hidden;\" />\n      "), true), "\n      <div\n        ").concat(this.htmlAttributes({
        "class": 'mj-menu-trigger',
        style: 'trigger'
      }), "\n      >\n        <label\n          ").concat(this.htmlAttributes({
        "for": key,
        "class": 'mj-menu-label',
        style: 'label',
        align: this.getAttribute('ico-align')
      }), "\n        >\n          <span\n            ").concat(this.htmlAttributes({
        "class": 'mj-menu-icon-open',
        style: 'icoOpen'
      }), "\n          >\n            ").concat(this.getAttribute('ico-open'), "\n          </span>\n          <span\n            ").concat(this.htmlAttributes({
        "class": 'mj-menu-icon-close',
        style: 'icoClose'
      }), "\n          >\n            ").concat(this.getAttribute('ico-close'), "\n          </span>\n        </label>\n      </div>\n    ");
    }
  }, {
    key: "render",
    value: function render() {
      return "\n        ".concat(this.getAttribute('hamburger') === 'hamburger' ? this.renderHamburger() : '', "\n        <div\n          ").concat(this.htmlAttributes({
        "class": 'mj-inline-links',
        style: this.htmlAttributes('div')
      }), "\n        >\n        ").concat((0, _conditionalTag["default"])("\n          <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"".concat(this.getAttribute('align'), "\">\n            <tr>\n        ")), "\n          ").concat(this.renderChildren(this.props.children, {
        attributes: {
          navbarBaseUrl: this.getAttribute('base-url')
        }
      }), "\n          ").concat((0, _conditionalTag["default"])("\n            </tr></table>\n          "), "\n        </div>\n    ");
    }
  }]);
  return MjNavbar;
}(_mjmlCore.BodyComponent);

exports["default"] = MjNavbar;
(0, _defineProperty2["default"])(MjNavbar, "allowedAttributes", {
  align: 'enum(left,center,right)',
  'base-url': 'string',
  hamburger: 'string',
  'ico-align': 'enum(left,center,right)',
  'ico-open': 'string',
  'ico-close': 'string',
  'ico-color': 'color',
  'ico-font-size': 'unit(px,%)',
  'ico-font-family': 'string',
  'ico-text-transform': 'string',
  'ico-padding': 'unit(px,%){1,4}',
  'ico-padding-left': 'unit(px,%)',
  'ico-padding-top': 'unit(px,%)',
  'ico-padding-right': 'unit(px,%)',
  'ico-padding-bottom': 'unit(px,%)',
  padding: 'unit(px,%){1,4}',
  'padding-left': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-bottom': 'unit(px,%)',
  'ico-text-decoration': 'string',
  'ico-line-height': 'unit(px,%,)'
});
(0, _defineProperty2["default"])(MjNavbar, "defaultAttributes", {
  align: 'center',
  'base-url': null,
  hamburger: null,
  'ico-align': 'center',
  'ico-open': '&#9776;',
  'ico-close': '&#8855;',
  'ico-color': '#000000',
  'ico-font-size': '30px',
  'ico-font-family': 'Ubuntu, Helvetica, Arial, sans-serif',
  'ico-text-transform': 'uppercase',
  'ico-padding': '10px',
  'ico-text-decoration': 'none',
  'ico-line-height': '30px'
});
module.exports = exports.default;