"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var _fp = require("lodash/fp");

var makeBackgroundString = (0, _fp.flow)((0, _fp.filter)(_fp.identity), (0, _fp.join)(' '));

var MjSection = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjSection, _BodyComponent);

  function MjSection() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2["default"])(this, MjSection);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2["default"])(this, (_getPrototypeOf2 = (0, _getPrototypeOf3["default"])(MjSection)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "getBackground", function () {
      return makeBackgroundString([_this.getAttribute('background-color')].concat((0, _toConsumableArray2["default"])(_this.hasBackground() ? ["url(".concat(_this.getAttribute('background-url'), ")"), "top center / ".concat(_this.getAttribute('background-size')), _this.getAttribute('background-repeat')] : [])));
    });
    return _this;
  }

  (0, _createClass2["default"])(MjSection, [{
    key: "getChildContext",
    value: function getChildContext() {
      var _this$getBoxWidths = this.getBoxWidths(),
          box = _this$getBoxWidths.box;

      return (0, _objectSpread2["default"])({}, this.context, {
        containerWidth: "".concat(box, "px")
      });
    }
  }, {
    key: "getStyles",
    value: function getStyles() {
      var containerWidth = this.context.containerWidth;
      var fullWidth = this.isFullWidth();
      var background = this.getAttribute('background-url') ? {
        background: this.getBackground()
      } : {
        background: this.getAttribute('background-color'),
        'background-color': this.getAttribute('background-color')
      };
      return {
        tableFullwidth: (0, _objectSpread2["default"])({}, fullWidth ? background : {}, {
          width: '100%',
          'border-radius': this.getAttribute('border-radius')
        }),
        table: (0, _objectSpread2["default"])({}, fullWidth ? {} : background, {
          width: '100%',
          'border-radius': this.getAttribute('border-radius')
        }),
        td: {
          border: this.getAttribute('border'),
          'border-bottom': this.getAttribute('border-bottom'),
          'border-left': this.getAttribute('border-left'),
          'border-right': this.getAttribute('border-right'),
          'border-top': this.getAttribute('border-top'),
          direction: this.getAttribute('direction'),
          'font-size': '0px',
          padding: this.getAttribute('padding'),
          'padding-bottom': this.getAttribute('padding-bottom'),
          'padding-left': this.getAttribute('padding-left'),
          'padding-right': this.getAttribute('padding-right'),
          'padding-top': this.getAttribute('padding-top'),
          'text-align': this.getAttribute('text-align')
        },
        div: (0, _objectSpread2["default"])({}, fullWidth ? {} : background, {
          margin: '0px auto',
          'border-radius': this.getAttribute('border-radius'),
          'max-width': containerWidth
        }),
        innerDiv: {
          'line-height': '0',
          'font-size': '0'
        }
      };
    }
  }, {
    key: "hasBackground",
    value: function hasBackground() {
      return this.getAttribute('background-url') != null;
    }
  }, {
    key: "isFullWidth",
    value: function isFullWidth() {
      return this.getAttribute('full-width') === 'full-width';
    }
  }, {
    key: "renderBefore",
    value: function renderBefore() {
      var containerWidth = this.context.containerWidth;
      return "\n      <!--[if mso | IE]>\n      <table\n        ".concat(this.htmlAttributes({
        align: 'center',
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        "class": (0, _mjmlCore.suffixCssClasses)(this.getAttribute('css-class'), 'outlook'),
        style: {
          width: "".concat(containerWidth)
        },
        width: parseInt(containerWidth, 10)
      }), "\n      >\n        <tr>\n          <td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\">\n      <![endif]-->\n    ");
    } // eslint-disable-next-line class-methods-use-this

  }, {
    key: "renderAfter",
    value: function renderAfter() {
      return "\n      <!--[if mso | IE]>\n          </td>\n        </tr>\n      </table>\n      <![endif]-->\n    ";
    }
  }, {
    key: "renderWrappedChildren",
    value: function renderWrappedChildren() {
      var children = this.props.children;
      return "\n      <!--[if mso | IE]>\n        <tr>\n      <![endif]-->\n      ".concat(this.renderChildren(children, {
        renderer: function renderer(component) {
          return component.constructor.isRawElement() ? component.render() : "\n          <!--[if mso | IE]>\n            <td\n              ".concat(component.htmlAttributes({
            align: component.getAttribute('align'),
            "class": (0, _mjmlCore.suffixCssClasses)(component.getAttribute('css-class'), 'outlook'),
            style: 'tdOutlook'
          }), "\n            >\n          <![endif]-->\n            ").concat(component.render(), "\n          <!--[if mso | IE]>\n            </td>\n          <![endif]-->\n    ");
        }
      }), "\n\n      <!--[if mso | IE]>\n        </tr>\n      <![endif]-->\n    ");
    }
  }, {
    key: "renderWithBackground",
    value: function renderWithBackground(content) {
      var fullWidth = this.isFullWidth();
      var containerWidth = this.context.containerWidth;
      return "\n      <!--[if mso | IE]>\n        <v:rect ".concat(this.htmlAttributes({
        style: fullWidth ? {
          'mso-width-percent': '1000'
        } : {
          width: containerWidth
        },
        'xmlns:v': 'urn:schemas-microsoft-com:vml',
        fill: 'true',
        stroke: 'false'
      }), ">\n        <v:fill ").concat(this.htmlAttributes({
        origin: '0.5, 0',
        position: '0.5, 0',
        src: this.getAttribute('background-url'),
        color: this.getAttribute('background-color'),
        type: 'tile'
      }), " />\n        <v:textbox style=\"mso-fit-shape-to-text:true\" inset=\"0,0,0,0\">\n      <![endif]-->\n          ").concat(content, "\n        <!--[if mso | IE]>\n        </v:textbox>\n      </v:rect>\n    <![endif]-->\n    ");
    }
  }, {
    key: "renderSection",
    value: function renderSection() {
      var hasBackground = this.hasBackground();
      return "\n      <div ".concat(this.htmlAttributes({
        "class": this.isFullWidth() ? null : this.getAttribute('css-class'),
        style: 'div'
      }), ">\n        ").concat(hasBackground ? "<div ".concat(this.htmlAttributes({
        style: 'innerDiv'
      }), ">") : '', "\n        <table\n          ").concat(this.htmlAttributes({
        align: 'center',
        background: this.isFullWidth() ? null : this.getAttribute('background-url'),
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        style: 'table'
      }), "\n        >\n          <tbody>\n            <tr>\n              <td\n                ").concat(this.htmlAttributes({
        style: 'td'
      }), "\n              >\n                <!--[if mso | IE]>\n                  <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n                <![endif]-->\n                  ").concat(this.renderWrappedChildren(), "\n                <!--[if mso | IE]>\n                  </table>\n                <![endif]-->\n              </td>\n            </tr>\n          </tbody>\n        </table>\n        ").concat(hasBackground ? '</div>' : '', "\n      </div>\n    ");
    }
  }, {
    key: "renderFullWidth",
    value: function renderFullWidth() {
      var content = this.hasBackground() ? this.renderWithBackground("\n        ".concat(this.renderBefore(), "\n        ").concat(this.renderSection(), "\n        ").concat(this.renderAfter(), "\n      ")) : "\n        ".concat(this.renderBefore(), "\n        ").concat(this.renderSection(), "\n        ").concat(this.renderAfter(), "\n      ");
      return "\n      <table\n        ".concat(this.htmlAttributes({
        align: 'center',
        "class": this.getAttribute('css-class'),
        background: this.getAttribute('background-url'),
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        style: 'tableFullwidth'
      }), "\n      >\n        <tbody>\n          <tr>\n            <td>\n              ").concat(content, "\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    ");
    }
  }, {
    key: "renderSimple",
    value: function renderSimple() {
      var section = this.renderSection();
      return "\n      ".concat(this.renderBefore(), "\n      ").concat(this.hasBackground() ? this.renderWithBackground(section) : section, "\n      ").concat(this.renderAfter(), "\n    ");
    }
  }, {
    key: "render",
    value: function render() {
      return this.isFullWidth() ? this.renderFullWidth() : this.renderSimple();
    }
  }]);
  return MjSection;
}(_mjmlCore.BodyComponent);

exports["default"] = MjSection;
(0, _defineProperty2["default"])(MjSection, "allowedAttributes", {
  'background-color': 'color',
  'background-url': 'string',
  'background-repeat': 'enum(repeat,no-repeat)',
  'background-size': 'string',
  border: 'string',
  'border-bottom': 'string',
  'border-left': 'string',
  'border-radius': 'string',
  'border-right': 'string',
  'border-top': 'string',
  direction: 'enum(ltr,rtl)',
  'full-width': 'enum(full-width)',
  padding: 'unit(px,%){1,4}',
  'padding-top': 'unit(px,%)',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'text-align': 'enum(left,center,right)',
  'text-padding': 'unit(px,%){1,4}'
});
(0, _defineProperty2["default"])(MjSection, "defaultAttributes", {
  'background-repeat': 'repeat',
  'background-size': 'auto',
  direction: 'ltr',
  padding: '20px 0',
  'text-align': 'center',
  'text-padding': '4px 4px 4px 0'
});
module.exports = exports.default;