"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var MjSocial = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjSocial, _BodyComponent);

  function MjSocial() {
    (0, _classCallCheck2["default"])(this, MjSocial);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjSocial).apply(this, arguments));
  }

  (0, _createClass2["default"])(MjSocial, [{
    key: "getStyles",
    // eslint-disable-next-line class-methods-use-this
    value: function getStyles() {
      return {
        tableVertical: {
          margin: '0px'
        }
      };
    }
  }, {
    key: "getSocialElementAttributes",
    value: function getSocialElementAttributes() {
      var _this = this;

      var base = {};

      if (this.getAttribute('inner-padding')) {
        base.padding = this.getAttribute('inner-padding');
      }

      return ['border-radius', 'color', 'font-family', 'font-size', 'font-weight', 'font-style', 'icon-size', 'icon-height', 'icon-padding', 'text-padding', 'line-height', 'text-decoration'].reduce(function (res, attr) {
        res[attr] = _this.getAttribute(attr);
        return res;
      }, base);
    }
  }, {
    key: "renderHorizontal",
    value: function renderHorizontal() {
      var _this2 = this;

      var children = this.props.children;
      return "\n     <!--[if mso | IE]>\n      <table\n        ".concat(this.htmlAttributes({
        align: this.getAttribute('align'),
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation'
      }), "\n      >\n        <tr>\n      <![endif]-->\n      ").concat(this.renderChildren(children, {
        attributes: this.getSocialElementAttributes(),
        renderer: function renderer(component) {
          return "\n            <!--[if mso | IE]>\n              <td>\n            <![endif]-->\n              <table\n                ".concat(component.htmlAttributes({
            align: _this2.getAttribute('align'),
            border: '0',
            cellpadding: '0',
            cellspacing: '0',
            role: 'presentation',
            style: {
              "float": 'none',
              display: 'inline-table'
            }
          }), "\n              >\n                ").concat(component.render(), "\n              </table>\n            <!--[if mso | IE]>\n              </td>\n            <![endif]-->\n          ");
        }
      }), "\n      <!--[if mso | IE]>\n          </tr>\n        </table>\n      <![endif]-->\n    ");
    }
  }, {
    key: "renderVertical",
    value: function renderVertical() {
      var children = this.props.children;
      return "\n      <table\n        ".concat(this.htmlAttributes({
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        style: 'tableVertical'
      }), "\n      >\n        ").concat(this.renderChildren(children, {
        attributes: this.getSocialElementAttributes()
      }), "\n      </table>\n    ");
    }
  }, {
    key: "render",
    value: function render() {
      return "\n      ".concat(this.getAttribute('mode') === 'horizontal' ? this.renderHorizontal() : this.renderVertical(), "\n    ");
    }
  }]);
  return MjSocial;
}(_mjmlCore.BodyComponent);

exports["default"] = MjSocial;
(0, _defineProperty2["default"])(MjSocial, "allowedAttributes", {
  align: 'enum(left,right,center)',
  'border-radius': 'unit(px,%)',
  'container-background-color': 'color',
  color: 'color',
  'font-family': 'string',
  'font-size': 'unit(px)',
  'font-style': 'string',
  'font-weight': 'string',
  'icon-size': 'unit(px,%)',
  'icon-height': 'unit(px,%)',
  'icon-padding': 'unit(px,%){1,4}',
  'inner-padding': 'unit(px,%){1,4}',
  'line-height': 'unit(px,%,)',
  mode: 'enum(horizontal,vertical)',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  padding: 'unit(px,%){1,4}',
  'table-layout': 'enum(auto,fixed)',
  'text-padding': 'unit(px,%){1,4}',
  'text-decoration': 'string',
  'vertical-align': 'enum(top,bottom,middle)'
});
(0, _defineProperty2["default"])(MjSocial, "defaultAttributes", {
  align: 'center',
  'border-radius': '3px',
  color: '#333333',
  'font-family': 'Ubuntu, Helvetica, Arial, sans-serif',
  'font-size': '13px',
  'icon-size': '20px',
  'inner-padding': null,
  'line-height': '22px',
  mode: 'horizontal',
  padding: '10px 25px',
  'text-decoration': 'none'
});
module.exports = exports.default;