"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectSpread3 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _mjmlCore = require("mjml-core");

var _lodash = require("lodash");

var IMG_BASE_URL = 'https://www.mailjet.com/images/theme/v1/icons/ico-social/';
var defaultSocialNetworks = {
  facebook: {
    'share-url': 'https://www.facebook.com/sharer/sharer.php?u=[[URL]]',
    'background-color': '#3b5998',
    src: "".concat(IMG_BASE_URL, "facebook.png")
  },
  twitter: {
    'share-url': 'https://twitter.com/home?status=[[URL]]',
    'background-color': '#55acee',
    src: "".concat(IMG_BASE_URL, "twitter.png")
  },
  google: {
    'share-url': 'https://plus.google.com/share?url=[[URL]]',
    'background-color': '#dc4e41',
    src: "".concat(IMG_BASE_URL, "google-plus.png")
  },
  pinterest: {
    'share-url': 'https://pinterest.com/pin/create/button/?url=[[URL]]&media=&description=',
    'background-color': '#bd081c',
    src: "".concat(IMG_BASE_URL, "pinterest.png")
  },
  linkedin: {
    'share-url': 'https://www.linkedin.com/shareArticle?mini=true&url=[[URL]]&title=&summary=&source=',
    'background-color': '#0077b5',
    src: "".concat(IMG_BASE_URL, "linkedin.png")
  },
  instagram: {
    'background-color': '#3f729b',
    src: "".concat(IMG_BASE_URL, "instagram.png")
  },
  web: {
    src: "".concat(IMG_BASE_URL, "web.png"),
    'background-color': '#4BADE9'
  },
  snapchat: {
    src: "".concat(IMG_BASE_URL, "snapchat.png"),
    'background-color': '#FFFA54'
  },
  youtube: {
    src: "".concat(IMG_BASE_URL, "youtube.png"),
    'background-color': '#EB3323'
  },
  tumblr: {
    src: "".concat(IMG_BASE_URL, "tumblr.png"),
    'share-url': 'https://www.tumblr.com/widgets/share/tool?canonicalUrl=[[URL]]',
    'background-color': '#344356'
  },
  github: {
    src: "".concat(IMG_BASE_URL, "github.png"),
    'background-color': '#000000'
  },
  xing: {
    src: "".concat(IMG_BASE_URL, "xing.png"),
    'share-url': 'https://www.xing.com/app/user?op=share&url=[[URL]]',
    'background-color': '#296366'
  },
  vimeo: {
    src: "".concat(IMG_BASE_URL, "vimeo.png"),
    'background-color': '#53B4E7'
  },
  medium: {
    src: "".concat(IMG_BASE_URL, "medium.png"),
    'background-color': '#000000'
  },
  soundcloud: {
    src: "".concat(IMG_BASE_URL, "soundcloud.png"),
    'background-color': '#EF7F31'
  },
  dribbble: {
    src: "".concat(IMG_BASE_URL, "dribbble.png"),
    'background-color': '#D95988'
  }
};
(0, _lodash.each)(defaultSocialNetworks, function (val, key) {
  defaultSocialNetworks["".concat(key, "-noshare")] = (0, _objectSpread3["default"])({}, val, {
    'share-url': '[[URL]]'
  });
});

var MjSocialElement = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjSocialElement, _BodyComponent);

  function MjSocialElement() {
    (0, _classCallCheck2["default"])(this, MjSocialElement);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjSocialElement).apply(this, arguments));
  }

  (0, _createClass2["default"])(MjSocialElement, [{
    key: "getStyles",
    value: function getStyles() {
      var _this$getSocialAttrib = this.getSocialAttributes(),
          iconSize = _this$getSocialAttrib['icon-size'],
          iconHeight = _this$getSocialAttrib['icon-height'],
          backgroundColor = _this$getSocialAttrib['background-color'];

      return {
        td: {
          padding: this.getAttribute('padding')
        },
        table: {
          background: backgroundColor,
          'border-radius': this.getAttribute('border-radius'),
          width: iconSize
        },
        icon: {
          padding: this.getAttribute('icon-padding'),
          'font-size': '0',
          height: iconHeight || iconSize,
          'vertical-align': 'middle',
          width: iconSize
        },
        img: {
          'border-radius': this.getAttribute('border-radius'),
          display: 'block'
        },
        tdText: {
          'vertical-align': 'middle',
          padding: this.getAttribute('text-padding')
        },
        text: {
          color: this.getAttribute('color'),
          'font-size': this.getAttribute('font-size'),
          'font-weight': this.getAttribute('font-weight'),
          'font-style': this.getAttribute('font-style'),
          'font-family': this.getAttribute('font-family'),
          'line-height': this.getAttribute('line-height'),
          'text-decoration': this.getAttribute('text-decoration')
        }
      };
    }
  }, {
    key: "getSocialAttributes",
    value: function getSocialAttributes() {
      var _this = this;

      var socialNetwork = defaultSocialNetworks[this.getAttribute('name')] || {};
      var href = this.getAttribute('href');

      if (href && (0, _lodash.get)(socialNetwork, 'share-url')) {
        href = socialNetwork['share-url'].replace('[[URL]]', href);
      }

      var attrs = ['icon-size', 'icon-height', 'src', 'background-color'].reduce(function (r, attr) {
        return (0, _objectSpread3["default"])({}, r, (0, _defineProperty2["default"])({}, attr, _this.getAttribute(attr) || socialNetwork[attr]));
      }, {});
      return (0, _objectSpread3["default"])({
        href: href
      }, attrs);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$getSocialAttrib2 = this.getSocialAttributes(),
          src = _this$getSocialAttrib2.src,
          href = _this$getSocialAttrib2.href,
          iconSize = _this$getSocialAttrib2['icon-size'],
          iconHeight = _this$getSocialAttrib2['icon-height'];

      var hasLink = !!this.getAttribute('href');
      return "\n      <tr\n        ".concat(this.htmlAttributes({
        "class": this.getAttribute('css-class')
      }), "\n      >\n        <td ").concat(this.htmlAttributes({
        style: 'td'
      }), ">\n          <table\n            ").concat(this.htmlAttributes({
        border: '0',
        cellpadding: '0',
        cellspacing: '0',
        role: 'presentation',
        style: 'table'
      }), "\n          >\n            <tr>\n              <td ").concat(this.htmlAttributes({
        style: 'icon'
      }), ">\n                ").concat(hasLink ? "<a ".concat(this.htmlAttributes({
        href: href,
        rel: this.getAttribute('rel'),
        target: this.getAttribute('target')
      }), ">") : '', "\n                    <img\n                      ").concat(this.htmlAttributes({
        alt: this.getAttribute('alt'),
        title: this.getAttribute('title'),
        height: parseInt(iconHeight || iconSize, 10),
        src: src,
        style: 'img',
        width: parseInt(iconSize, 10)
      }), "\n                    />\n                  ").concat(hasLink ? "</a>" : '', "\n                </td>\n              </tr>\n          </table>\n        </td>\n        ").concat(this.getContent() ? "\n          <td ".concat(this.htmlAttributes({
        style: 'tdText'
      }), ">\n            ").concat(hasLink ? "<a\n                ".concat(this.htmlAttributes({
        href: href,
        style: 'text',
        rel: this.getAttribute('rel'),
        target: this.getAttribute('target')
      }), ">") : "<span\n                    ".concat(this.htmlAttributes({
        style: 'text'
      }), ">"), "\n              ").concat(this.getContent(), "\n            ").concat(hasLink ? "</a>" : '</span>', "\n          </td>\n          ") : '', "\n      </tr>\n    ");
    }
  }]);
  return MjSocialElement;
}(_mjmlCore.BodyComponent);

exports["default"] = MjSocialElement;
(0, _defineProperty2["default"])(MjSocialElement, "endingTag", true);
(0, _defineProperty2["default"])(MjSocialElement, "allowedAttributes", {
  align: 'enum(left,center,right)',
  'background-color': 'color',
  color: 'color',
  'border-radius': 'unit(px)',
  'font-family': 'string',
  'font-size': 'unit(px)',
  'font-style': 'string',
  'font-weight': 'string',
  href: 'string',
  'icon-size': 'unit(px,%)',
  'icon-height': 'unit(px,%)',
  'icon-padding': 'unit(px,%){1,4}',
  'line-height': 'unit(px,%,)',
  name: 'string',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  padding: 'unit(px,%){1,4}',
  'text-padding': 'unit(px,%){1,4}',
  src: 'string',
  alt: 'string',
  title: 'string',
  target: 'string',
  'text-decoration': 'string'
});
(0, _defineProperty2["default"])(MjSocialElement, "defaultAttributes", {
  align: 'left',
  color: '#000',
  'border-radius': '3px',
  'font-family': 'Ubuntu, Helvetica, Arial, sans-serif',
  'font-size': '13px',
  'line-height': '1',
  padding: '4px',
  'text-padding': '4px 4px 4px 0',
  target: '_blank',
  'text-decoration': 'none'
});
module.exports = exports.default;