"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectSpread3 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _widthParser2 = _interopRequireDefault(require("mjml-core/lib/helpers/widthParser"));

var _mjmlCore = require("mjml-core");

var _lodash = require("lodash");

var MjTable = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjTable, _BodyComponent);

  function MjTable() {
    (0, _classCallCheck2["default"])(this, MjTable);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjTable).apply(this, arguments));
  }

  (0, _createClass2["default"])(MjTable, [{
    key: "getStyles",
    value: function getStyles() {
      return {
        table: {
          color: this.getAttribute('color'),
          'font-family': this.getAttribute('font-family'),
          'font-size': this.getAttribute('font-size'),
          'line-height': this.getAttribute('line-height'),
          'table-layout': this.getAttribute('table-layout'),
          width: this.getAttribute('width'),
          border: this.getAttribute('border')
        }
      };
    }
  }, {
    key: "getWidth",
    value: function getWidth() {
      var width = this.getAttribute('width');

      var _widthParser = (0, _widthParser2["default"])(width),
          parsedWidth = _widthParser.parsedWidth,
          unit = _widthParser.unit;

      return unit === '%' ? width : parsedWidth;
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var tableAttributes = (0, _lodash.reduce)(['cellpadding', 'cellspacing'], function (acc, v) {
        return (0, _objectSpread3["default"])({}, acc, (0, _defineProperty2["default"])({}, v, _this.getAttribute(v)));
      }, {});
      return "\n      <table\n        ".concat(this.htmlAttributes((0, _objectSpread3["default"])({}, tableAttributes, {
        width: this.getWidth(),
        border: '0',
        style: 'table'
      })), "\n      >\n        ").concat(this.getContent(), "\n      </table>\n    ");
    }
  }]);
  return MjTable;
}(_mjmlCore.BodyComponent);

exports["default"] = MjTable;
(0, _defineProperty2["default"])(MjTable, "endingTag", true);
(0, _defineProperty2["default"])(MjTable, "allowedAttributes", {
  align: 'enum(left,right,center)',
  border: 'string',
  cellpadding: 'integer',
  cellspacing: 'integer',
  'container-background-color': 'color',
  color: 'color',
  'font-family': 'string',
  'font-size': 'unit(px)',
  'font-weight': 'string',
  'line-height': 'unit(px,%,)',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  padding: 'unit(px,%){1,4}',
  'table-layout': 'enum(auto,fixed,initial,inherit)',
  'vertical-align': 'enum(top,bottom,middle)',
  width: 'unit(px,%)'
});
(0, _defineProperty2["default"])(MjTable, "defaultAttributes", {
  align: 'left',
  border: 'none',
  cellpadding: '0',
  cellspacing: '0',
  color: '#000000',
  'font-family': 'Ubuntu, Helvetica, Arial, sans-serif',
  'font-size': '13px',
  'line-height': '22px',
  padding: '10px 25px',
  'table-layout': 'auto',
  width: '100%'
});
module.exports = exports.default;