'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRule = registerRule;

var _warning = require('warning');

var _warning2 = _interopRequireDefault(_warning);

var _lodash = require('lodash');

var _mjmlCore = require('mjml-core');

var _rules = require('./rules');

var rules = _interopRequireWildcard(_rules);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MJMLRulesCollection = {};

function registerRule(rule, name) {
  if (typeof rule !== 'function' || rule.length !== 2) {
    return (0, _warning2.default)(false, 'Your rule must be a function and must have two parameters which are the element to validate and the components object imported from mjml-core');
  }

  if (name) {
    MJMLRulesCollection[name] = rule;
  } else {
    MJMLRulesCollection[rule.name] = rule;
  }

  return true;
}

(0, _lodash.mapKeys)(rules, function (func, name) {
  return registerRule(func, name, { components: _mjmlCore.components });
});

exports.default = MJMLRulesCollection;