'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDependencies = undefined;

var _lodash = require('lodash');

// eslint-disable-next-line consistent-return
function mergeArrays(objValue, srcValue) {
  if ((0, _lodash.isArray)(objValue) && (0, _lodash.isArray)(srcValue)) {
    return objValue.concat(srcValue);
  }
}

var dependencies = {};

var registerDependencies = exports.registerDependencies = function registerDependencies(dep) {
  return (0, _lodash.mergeWith)(dependencies, dep, mergeArrays);
};

exports.default = dependencies;