'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ruleError;
function formatInclude(element) {
  var includedIn = element.includedIn;

  if (!(includedIn && includedIn.length)) return '';

  var formattedIncluded = includedIn.slice().reverse().map(function (_ref) {
    var line = _ref.line,
        file = _ref.file;
    return 'line ' + line + ' of file ' + file;
  }).join(', itself included at ');

  return ', included at ' + formattedIncluded;
}

function ruleError(message, element) {
  var line = element.line,
      tagName = element.tagName,
      absoluteFilePath = element.absoluteFilePath;


  return {
    line: line,
    message: message,
    tagName: tagName,
    formattedMessage: 'Line ' + line + ' of ' + absoluteFilePath + formatInclude(element) + ' (' + tagName + ') \u2014 ' + message
  };
}
module.exports = exports['default'];