'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = validChildren;

var _filter = require('lodash/filter');

var _filter2 = _interopRequireDefault(_filter);

var _includes = require('lodash/includes');

var _includes2 = _interopRequireDefault(_includes);

var _keys = require('lodash/keys');

var _keys2 = _interopRequireDefault(_keys);

var _dependencies = require('../dependencies');

var _dependencies2 = _interopRequireDefault(_dependencies);

var _ruleError = require('./ruleError');

var _ruleError2 = _interopRequireDefault(_ruleError);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function validChildren(element, _ref) {
  var components = _ref.components,
      skipElements = _ref.skipElements;
  var children = element.children,
      tagName = element.tagName;


  var Component = components[tagName];

  if (!Component || !children || !children.length) {
    return null;
  }

  return (0, _filter2.default)(children.map(function (child) {
    var childTagName = child.tagName;
    var ChildComponent = components[childTagName];
    var parentDependencies = _dependencies2.default[tagName] || [];

    if (!ChildComponent || (0, _includes2.default)(skipElements, childTagName) || (0, _includes2.default)(parentDependencies, childTagName) || parentDependencies.some(function (dep) {
      return dep instanceof RegExp && dep.test(childTagName);
    })) {
      return null;
    }

    var allowedDependencies = (0, _keys2.default)(_dependencies2.default).filter(function (key) {
      return (0, _includes2.default)(_dependencies2.default[key], childTagName) || _dependencies2.default[key].some(function (dep) {
        return dep instanceof RegExp && dep.test(childTagName);
      });
    });

    return (0, _ruleError2.default)(childTagName + ' cannot be used inside ' + tagName + ', only inside: ' + allowedDependencies.join(', '), child);
  }));
}
module.exports = exports['default'];