"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRule = registerRule;
exports["default"] = void 0;

var _warning = _interopRequireDefault(require("warning"));

var _lodash = require("lodash");

var rules = _interopRequireWildcard(require("./rules"));

var MJMLRulesCollection = {};

function registerRule(rule, name) {
  if (typeof rule !== 'function') {
    return (0, _warning["default"])(false, 'Your rule must be a function');
  }

  if (name) {
    MJMLRulesCollection[name] = rule;
  } else {
    MJMLRulesCollection[rule.name] = rule;
  }

  return true;
}

(0, _lodash.mapKeys)(rules, function (func, name) {
  return registerRule(func, name);
});
var _default = MJMLRulesCollection;
exports["default"] = _default;