"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.registerDependencies = void 0;

var _lodash = require("lodash");

// eslint-disable-next-line consistent-return
function mergeArrays(objValue, srcValue) {
  if ((0, _lodash.isArray)(objValue) && (0, _lodash.isArray)(srcValue)) {
    return objValue.concat(srcValue);
  }
}

var dependencies = {};

var registerDependencies = function registerDependencies(dep) {
  return (0, _lodash.mergeWith)(dependencies, dep, mergeArrays);
};

exports.registerDependencies = registerDependencies;
var _default = dependencies;
exports["default"] = _default;