"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = MJMLValidator;
Object.defineProperty(exports, "rulesCollection", {
  enumerable: true,
  get: function get() {
    return _MJMLRulesCollection["default"];
  }
});
Object.defineProperty(exports, "registerRule", {
  enumerable: true,
  get: function get() {
    return _MJMLRulesCollection.registerRule;
  }
});
Object.defineProperty(exports, "dependencies", {
  enumerable: true,
  get: function get() {
    return _dependencies["default"];
  }
});
Object.defineProperty(exports, "registerDependencies", {
  enumerable: true,
  get: function get() {
    return _dependencies.registerDependencies;
  }
});
exports.formatValidationError = void 0;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _lodash = require("lodash");

var _ruleError = _interopRequireDefault(require("./rules/ruleError"));

var _MJMLRulesCollection = _interopRequireWildcard(require("./MJMLRulesCollection"));

var _dependencies = _interopRequireWildcard(require("./dependencies"));

var SKIP_ELEMENTS = ['mjml'];
var formatValidationError = _ruleError["default"];
exports.formatValidationError = formatValidationError;

function MJMLValidator(element) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var children = element.children,
      tagName = element.tagName;
  var errors;
  var skipElements = options.skipElements || SKIP_ELEMENTS;

  if (!(0, _lodash.includes)(skipElements, tagName)) {
    errors = (0, _lodash.flatten)(_lodash.concat.apply(void 0, [errors].concat((0, _toConsumableArray2["default"])((0, _lodash.values)(_MJMLRulesCollection["default"]).map(function (rule) {
      return rule(element, (0, _objectSpread2["default"])({
        skipElements: skipElements
      }, options));
    })))));
  }

  if (children && children.length > 0) {
    errors = (0, _lodash.flatten)(_lodash.concat.apply(void 0, [errors].concat((0, _toConsumableArray2["default"])(children.map(function (child) {
      return MJMLValidator(child, options);
    })))));
  }

  return (0, _lodash.filter)(errors);
}