"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = errorAttr;

var _ruleError = _interopRequireDefault(require("./ruleError"));

function errorAttr(element) {
  var errors = element.errors;
  if (!errors) return null;
  return errors.map(function (error) {
    switch (error.type) {
      case 'include':
        {
          var _error$params = error.params,
              file = _error$params.file,
              partialPath = _error$params.partialPath;
          return (0, _ruleError["default"])("mj-include fails to read file : ".concat(file, " at ").concat(partialPath), element);
        }

      default:
        return null;
    }
  });
}

module.exports = exports.default;