'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = validateTag;

var _lodash = require('lodash');

var _ruleError = require('./ruleError');

var _ruleError2 = _interopRequireDefault(_ruleError);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function validateTag(element, _ref) {
  var components = _ref.components;
  var attributes = element.attributes;

  var error = (0, _lodash.find)(attributes, 'mj-error');
  if (!error) return null;

  return (0, _ruleError2.default)(error, element);
}
module.exports = exports['default'];