"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = ruleError;

function formatInclude(element) {
  var includedIn = element.includedIn;
  if (!(includedIn && includedIn.length)) return '';
  var formattedIncluded = includedIn.slice().reverse().map(function (_ref) {
    var line = _ref.line,
        file = _ref.file;
    return "line ".concat(line, " of file ").concat(file);
  }).join(', itself included at ');
  return ", included at ".concat(formattedIncluded);
}

function ruleError(message, element) {
  var line = element.line,
      tagName = element.tagName,
      absoluteFilePath = element.absoluteFilePath;
  return {
    line: line,
    message: message,
    tagName: tagName,
    formattedMessage: "Line ".concat(line, " of ").concat(absoluteFilePath).concat(formatInclude(element), " (").concat(tagName, ") \u2014 ").concat(message)
  };
}

module.exports = exports.default;