"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = validateAttribute;

var _concat = _interopRequireDefault(require("lodash/concat"));

var _keys = _interopRequireDefault(require("lodash/keys"));

var _includes = _interopRequireDefault(require("lodash/includes"));

var _filter = _interopRequireDefault(require("lodash/filter"));

var _ruleError = _interopRequireDefault(require("./ruleError"));

var WHITELIST = ['mj-class', 'css-class'];

function validateAttribute(element, _ref) {
  var components = _ref.components;
  var attributes = element.attributes,
      tagName = element.tagName;
  var Component = components[tagName];

  if (!Component) {
    return null;
  }

  var availableAttributes = (0, _concat["default"])((0, _keys["default"])(Component.allowedAttributes), WHITELIST);
  var unknownAttributes = (0, _filter["default"])((0, _keys["default"])(attributes), function (attribute) {
    return !(0, _includes["default"])(availableAttributes, attribute);
  });

  if (unknownAttributes.length === 0) {
    return null;
  }

  var _attribute$illegal = {
    attribute: unknownAttributes.length > 1 ? 'Attributes' : 'Attribute',
    illegal: unknownAttributes.length > 1 ? 'are illegal' : 'is illegal'
  },
      attribute = _attribute$illegal.attribute,
      illegal = _attribute$illegal.illegal;
  return (0, _ruleError["default"])("".concat(attribute, " ").concat(unknownAttributes.join(', '), " ").concat(illegal), element);
}

module.exports = exports.default;