"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = validChildren;

var _filter = _interopRequireDefault(require("lodash/filter"));

var _includes = _interopRequireDefault(require("lodash/includes"));

var _keys = _interopRequireDefault(require("lodash/keys"));

var _dependencies = _interopRequireDefault(require("../dependencies"));

var _ruleError = _interopRequireDefault(require("./ruleError"));

function validChildren(element, _ref) {
  var components = _ref.components,
      skipElements = _ref.skipElements;
  var children = element.children,
      tagName = element.tagName;
  var Component = components[tagName];

  if (!Component || !children || !children.length) {
    return null;
  }

  return (0, _filter["default"])(children.map(function (child) {
    var childTagName = child.tagName;
    var ChildComponent = components[childTagName];
    var parentDependencies = _dependencies["default"][tagName] || [];

    if (!ChildComponent || (0, _includes["default"])(skipElements, childTagName) || (0, _includes["default"])(parentDependencies, childTagName) || parentDependencies.some(function (dep) {
      return dep instanceof RegExp && dep.test(childTagName);
    })) {
      return null;
    }

    var allowedDependencies = (0, _keys["default"])(_dependencies["default"]).filter(function (key) {
      return (0, _includes["default"])(_dependencies["default"][key], childTagName) || _dependencies["default"][key].some(function (dep) {
        return dep instanceof RegExp && dep.test(childTagName);
      });
    });
    return (0, _ruleError["default"])("".concat(childTagName, " cannot be used inside ").concat(tagName, ", only inside: ").concat(allowedDependencies.join(', ')), child);
  }));
}

module.exports = exports.default;