"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = validateTag;

var _lodash = require("lodash");

var _ruleError = _interopRequireDefault(require("./ruleError"));

// Tags that have no associated components but are allowed even so
var componentLessTags = ['mj-all', 'mj-class'];

function validateTag(element, _ref) {
  var components = _ref.components;
  var tagName = element.tagName;
  if ((0, _lodash.includes)(componentLessTags, tagName)) return null;
  var Component = components[tagName];

  if (!Component) {
    return (0, _ruleError["default"])("Element ".concat(tagName, " doesn't exist or is not registered"), element);
  }

  return null;
}

module.exports = exports.default;