# ![ml5](https://user-images.githubusercontent.com/10605821/41332516-2ee26714-6eac-11e8-83e4-a40b8761e764.png)
[![All Contributors](https://img.shields.io/badge/all_contributors-86-orange.svg?style=flat-square)](#contributors)


[![BrowserStack Status](https://www.browserstack.com/automate/badge.svg?badge_key=QVNDdlkvMzNYSmhRRWlweXlIOTBENkd0MDBCOUJlbmFVZFRneFIzNlh4az0tLXA4S0loSGNlVUc2V2I3cVdLdXBKdGc9PQ==--8a5e5bfd3eafbba0702c02ec57ffec9d627a78ef)](https://www.browserstack.com/automate/public-build/QVNDdlkvMzNYSmhRRWlweXlIOTBENkd0MDBCOUJlbmFVZFRneFIzNlh4az0tLXA4S0loSGNlVUc2V2I3cVdLdXBKdGc9PQ==--8a5e5bfd3eafbba0702c02ec57ffec9d627a78ef)[![Version](https://img.shields.io/npm/v/ml5.svg?style=flat-square)](https://www.npmjs.com/package/ml5)
[![Twitter Follow](https://img.shields.io/twitter/follow/espadrine.svg?style=social&label=Follow)](https://twitter.com/ml5js)



**_This project is currently in development._**

## Friendly machine learning for the web!

ml5.js aims to make machine learning approachable for a broad audience of artists, creative coders, and students. The library provides access to machine learning algorithms and models in the browser, building on top of [TensorFlow.js](https://js.tensorflow.org/).

The library is supported by code examples, tutorials, and sample data sets with an emphasis on ethical computing. Bias in data, stereotypical harms, and responsible crowdsourcing are part of the documentation around data collection and usage.

ml5.js is heavily inspired by [Processing](https://processing.org/) and [p5.js](https://p5js.org/).

## Usage

There are several ways you can use the ml5.js library:










<p id="latest-version">

* You can use the latest version (0.5.0) by adding it to the head section of your HTML document:

**v0.5.0**

    <script src="https://unpkg.com/ml5@0.5.0/dist/ml5.min.js" type="text/javascript"></script>

</p data-id="latest-version">
    









* If you need to use an earlier version for any reason, you can change the version number. The [previous versions of ml5 can be found here](https://www.npmjs.com/package/ml5). You can use those previous versions by replacing `<version>` with the ml5 version of interest:

```html
<script src="https://unpkg.com/ml5@<version>/dist/ml5.min.js" type="text/javascript"></script>
```

For example:
```html
<script src="https://unpkg.com/ml5@0.4.1/dist/ml5.min.js" type="text/javascript"></script>
```

* You can also reference "latest", but we do not recommend this as your code may break as we update ml5.

```html
<script src="https://unpkg.com/ml5@latest/dist/ml5.min.js" type="text/javascript"></script>
```

## Resources

- [Getting Started](https://ml5js.org/getting-started/)
- [API Reference](https://ml5js.org/reference/)
- [Examples](https://github.com/ml5js/ml5-examples)
- [Community](https://ml5js.org/community)
- [FAQ](https://ml5js.org/getting-started/faq/)

## Standalone Examples

You can find a collection of standalone examples in this repository: [github.com/ml5js/ml5-examples](https://github.com/ml5js/ml5-examples)

These examples are meant to serve as an introduction to the library and machine learning concepts.

## Code of Conduct
We believe in a friendly internet and community as much as we do in building friendly machine learning for the web. Please refer to our [CODE OF CONDUCT](CODE_OF_CONDUCT.md) for our rules for interacting with ml5 as a developer, contributor, or user.

## Contributing
Want to be a **contributor 🏗 to the ml5.js library**? If yes and you're interested to submit new features, fix bugs, or help develop the ml5.js ecosystem, please go to our [CONTRIBUTING](CONTRIBUTING.md) documentation to get started.

See [CONTRIBUTING](CONTRIBUTING.md) 🛠

## Acknowledgements

ml5.js is supported by the time and dedication of open source developers from all over the world. Funding and support is generously provided by a [Google Education grant](https://edu.google.com/giving/?modal_active=none) at NYU's ITP/IMA program.

Many thanks [BrowserStack](https://www.browserstack.com/) for providing testing support.

## Contributors

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="http://www.shiffman.net"><img src="https://avatars0.githubusercontent.com/u/191758?v=4" width="100px;" alt=""/><br /><sub><b>Daniel Shiffman</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=shiffman" title="Code">💻</a> <a href="#example-shiffman" title="Examples">💡</a> <a href="#projectManagement-shiffman" title="Project Management">📆</a> <a href="https://github.com/ml5js/ml5-library/pulls?q=is%3Apr+reviewed-by%3Ashiffman" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/ml5js/ml5-library/commits?author=shiffman" title="Tests">⚠️</a> <a href="#video-shiffman" title="Videos">📹</a></td>
    <td align="center"><a href="https://cvalenzuelab.com/"><img src="https://avatars0.githubusercontent.com/u/10605821?v=4" width="100px;" alt=""/><br /><sub><b>Cristóbal Valenzuela</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=cvalenzuela" title="Code">💻</a> <a href="#example-cvalenzuela" title="Examples">💡</a> <a href="https://github.com/ml5js/ml5-library/pulls?q=is%3Apr+reviewed-by%3Acvalenzuela" title="Reviewed Pull Requests">👀</a> <a href="#tool-cvalenzuela" title="Tools">🔧</a> <a href="https://github.com/ml5js/ml5-library/commits?author=cvalenzuela" title="Tests">⚠️</a></td>
    <td align="center"><a href="https://1023.io"><img src="https://avatars3.githubusercontent.com/u/8662372?v=4" width="100px;" alt=""/><br /><sub><b>Yining Shi</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=yining1023" title="Code">💻</a> <a href="#example-yining1023" title="Examples">💡</a> <a href="https://github.com/ml5js/ml5-library/pulls?q=is%3Apr+reviewed-by%3Ayining1023" title="Reviewed Pull Requests">👀</a> <a href="#tool-yining1023" title="Tools">🔧</a> <a href="https://github.com/ml5js/ml5-library/commits?author=yining1023" title="Tests">⚠️</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3Ayining1023" title="Bug reports">🐛</a></td>
    <td align="center"><a href="http://www.hannahishere.com"><img src="https://avatars0.githubusercontent.com/u/1385308?v=4" width="100px;" alt=""/><br /><sub><b>Hannah Davis</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=handav" title="Code">💻</a> <a href="#example-handav" title="Examples">💡</a></td>
    <td align="center"><a href="https://jk-lee.com/"><img src="https://avatars1.githubusercontent.com/u/3622055?v=4" width="100px;" alt=""/><br /><sub><b>Joey Lee</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=joeyklee" title="Code">💻</a> <a href="#example-joeyklee" title="Examples">💡</a> <a href="https://github.com/ml5js/ml5-library/pulls?q=is%3Apr+reviewed-by%3Ajoeyklee" title="Reviewed Pull Requests">👀</a> <a href="#content-joeyklee" title="Content">🖋</a> <a href="https://github.com/ml5js/ml5-library/commits?author=joeyklee" title="Tests">⚠️</a></td>
    <td align="center"><a href="https://github.com/AshleyJaneLewis"><img src="https://avatars3.githubusercontent.com/u/43127855?v=4" width="100px;" alt=""/><br /><sub><b>AshleyJaneLewis</b></sub></a><br /><a href="#blog-AshleyJaneLewis" title="Blogposts">📝</a> <a href="#design-AshleyJaneLewis" title="Design">🎨</a> <a href="#eventOrganizing-AshleyJaneLewis" title="Event Organizing">📋</a> <a href="#content-AshleyJaneLewis" title="Content">🖋</a></td>
    <td align="center"><a href="https://ellennickles.site/"><img src="https://avatars2.githubusercontent.com/u/31713501?v=4" width="100px;" alt=""/><br /><sub><b>Ellen Nickles</b></sub></a><br /><a href="#blog-ellennickles" title="Blogposts">📝</a> <a href="#content-ellennickles" title="Content">🖋</a> <a href="#ideas-ellennickles" title="Ideas, Planning, & Feedback">🤔</a> <a href="#tutorial-ellennickles" title="Tutorials">✅</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://www.itayniv.com"><img src="https://avatars1.githubusercontent.com/u/5209486?v=4" width="100px;" alt=""/><br /><sub><b>Itay Niv</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=itayniv" title="Code">💻</a> <a href="#example-itayniv" title="Examples">💡</a></td>
    <td align="center"><a href="http://nikitahuggins.com"><img src="https://avatars2.githubusercontent.com/u/18563958?v=4" width="100px;" alt=""/><br /><sub><b>Nikita Huggins</b></sub></a><br /><a href="#blog-nikitahuggins" title="Blogposts">📝</a> <a href="#content-nikitahuggins" title="Content">🖋</a> <a href="#ideas-nikitahuggins" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://www.arnabchakravarty.com"><img src="https://avatars2.githubusercontent.com/u/19427655?v=4" width="100px;" alt=""/><br /><sub><b>Arnab Chakravarty</b></sub></a><br /><a href="#content-AbolTaabol" title="Content">🖋</a> <a href="#userTesting-AbolTaabol" title="User Testing">📓</a></td>
    <td align="center"><a href="http://www.aidanjnelson.com/"><img src="https://avatars2.githubusercontent.com/u/6486359?v=4" width="100px;" alt=""/><br /><sub><b>Aidan Nelson</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=AidanNelson" title="Code">💻</a> <a href="#example-AidanNelson" title="Examples">💡</a></td>
    <td align="center"><a href="http://portfolio.steins.live"><img src="https://avatars1.githubusercontent.com/u/23213772?v=4" width="100px;" alt=""/><br /><sub><b>WenheLI</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=WenheLI" title="Code">💻</a> <a href="#example-WenheLI" title="Examples">💡</a> <a href="#maintenance-WenheLI" title="Maintenance">🚧</a> <a href="#ideas-WenheLI" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://tinysubversions.com"><img src="https://avatars3.githubusercontent.com/u/266454?v=4" width="100px;" alt=""/><br /><sub><b>Darius Kazemi</b></sub></a><br /><a href="#ideas-dariusk" title="Ideas, Planning, & Feedback">🤔</a> <a href="#question-dariusk" title="Answering Questions">💬</a></td>
    <td align="center"><a href="https://wangdingsu.com"><img src="https://avatars1.githubusercontent.com/u/26081991?v=4" width="100px;" alt=""/><br /><sub><b>Dingsu Wang</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=Derek-Wds" title="Code">💻</a> <a href="#example-Derek-Wds" title="Examples">💡</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/garym140"><img src="https://avatars1.githubusercontent.com/u/30574513?v=4" width="100px;" alt=""/><br /><sub><b>garym140</b></sub></a><br /><a href="#content-garym140" title="Content">🖋</a> <a href="#blog-garym140" title="Blogposts">📝</a> <a href="#ideas-garym140" title="Ideas, Planning, & Feedback">🤔</a> <a href="#userTesting-garym140" title="User Testing">📓</a></td>
    <td align="center"><a href="http://genekogan.com"><img src="https://avatars3.githubusercontent.com/u/1335251?v=4" width="100px;" alt=""/><br /><sub><b>Gene Kogan</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=genekogan" title="Code">💻</a> <a href="#example-genekogan" title="Examples">💡</a> <a href="#ideas-genekogan" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://hhayeon.com"><img src="https://avatars1.githubusercontent.com/u/22086451?v=4" width="100px;" alt=""/><br /><sub><b>Hayley Hwang</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=hhayley" title="Code">💻</a> <a href="#example-hhayley" title="Examples">💡</a> <a href="#ideas-hhayley" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://lisajamhoury.com"><img src="https://avatars0.githubusercontent.com/u/7552772?v=4" width="100px;" alt=""/><br /><sub><b>Lisa Jamhoury</b></sub></a><br /><a href="#example-lisajamhoury" title="Examples">💡</a> <a href="#ideas-lisajamhoury" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://www.matamala.info"><img src="https://avatars2.githubusercontent.com/u/5123955?v=4" width="100px;" alt=""/><br /><sub><b>Alejandro Matamala Ortiz</b></sub></a><br /><a href="#design-matamalaortiz" title="Design">🎨</a> <a href="#content-matamalaortiz" title="Content">🖋</a> <a href="#blog-matamalaortiz" title="Blogposts">📝</a></td>
    <td align="center"><a href="http://mayaontheinter.net"><img src="https://avatars0.githubusercontent.com/u/8224678?v=4" width="100px;" alt=""/><br /><sub><b>Maya Man</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=mayaman" title="Code">💻</a> <a href="#example-mayaman" title="Examples">💡</a></td>
    <td align="center"><a href="http://mimionuoha.com"><img src="https://avatars0.githubusercontent.com/u/1565846?v=4" width="100px;" alt=""/><br /><sub><b>Mimi Onuoha</b></sub></a><br /><a href="#ideas-MimiOnuoha" title="Ideas, Planning, & Feedback">🤔</a> <a href="#content-MimiOnuoha" title="Content">🖋</a> <a href="https://github.com/ml5js/ml5-library/pulls?q=is%3Apr+reviewed-by%3AMimiOnuoha" title="Reviewed Pull Requests">👀</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://i.yuuno.cc/"><img src="https://avatars1.githubusercontent.com/u/18514672?v=4" width="100px;" alt=""/><br /><sub><b>Yuuno, Hibiki</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=NHibiki" title="Code">💻</a> <a href="#example-NHibiki" title="Examples">💡</a> <a href="#maintenance-NHibiki" title="Maintenance">🚧</a></td>
    <td align="center"><a href="http://www.danioved.com/"><img src="https://avatars3.githubusercontent.com/u/891755?v=4" width="100px;" alt=""/><br /><sub><b>Dan Oved</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=oveddan" title="Code">💻</a> <a href="#example-oveddan" title="Examples">💡</a> <a href="#question-oveddan" title="Answering Questions">💬</a> <a href="#ideas-oveddan" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://anothersideproject.co"><img src="https://avatars0.githubusercontent.com/u/7053425?v=4" width="100px;" alt=""/><br /><sub><b>Stephanie Koltun</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=stephkoltun" title="Code">💻</a> <a href="#example-stephkoltun" title="Examples">💡</a> <a href="#content-stephkoltun" title="Content">🖋</a> <a href="#blog-stephkoltun" title="Blogposts">📝</a> <a href="#design-stephkoltun" title="Design">🎨</a></td>
    <td align="center"><a href="https://github.com/viztopia"><img src="https://avatars3.githubusercontent.com/u/37890050?v=4" width="100px;" alt=""/><br /><sub><b>YG Zhang</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=viztopia" title="Code">💻</a> <a href="#example-viztopia" title="Examples">💡</a> <a href="#ideas-viztopia" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://www.wenqi.li"><img src="https://avatars1.githubusercontent.com/u/22087042?v=4" width="100px;" alt=""/><br /><sub><b>Wenqi Li</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=wenqili" title="Code">💻</a> <a href="#example-wenqili" title="Examples">💡</a> <a href="#infra-wenqili" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
    <td align="center"><a href="http://brentlbailey.com"><img src="https://avatars3.githubusercontent.com/u/12499678?v=4" width="100px;" alt=""/><br /><sub><b>Brent Bailey</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=brondle" title="Tests">⚠️</a> <a href="https://github.com/ml5js/ml5-library/commits?author=brondle" title="Code">💻</a> <a href="#example-brondle" title="Examples">💡</a></td>
    <td align="center"><a href="https://github.com/Jonarod"><img src="https://avatars3.githubusercontent.com/u/6122703?v=4" width="100px;" alt=""/><br /><sub><b>Jonarod</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=Jonarod" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://jazztap.github.io"><img src="https://avatars2.githubusercontent.com/u/15673619?v=4" width="100px;" alt=""/><br /><sub><b>Jasmine Otto</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=JazzTap" title="Code">💻</a> <a href="https://github.com/ml5js/ml5-library/commits?author=JazzTap" title="Tests">⚠️</a> <a href="#example-JazzTap" title="Examples">💡</a></td>
    <td align="center"><a href="https://twitter.com/zaidalyafeai"><img src="https://avatars2.githubusercontent.com/u/15667714?v=4" width="100px;" alt=""/><br /><sub><b>Zaid Alyafeai</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=zaidalyafeai" title="Code">💻</a> <a href="#example-zaidalyafeai" title="Examples">💡</a> <a href="#ideas-zaidalyafeai" title="Ideas, Planning, & Feedback">🤔</a> <a href="#question-zaidalyafeai" title="Answering Questions">💬</a></td>
    <td align="center"><a href="https://alca.tv"><img src="https://avatars2.githubusercontent.com/u/7132646?v=4" width="100px;" alt=""/><br /><sub><b>Jacob Foster</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=AlcaDesign" title="Code">💻</a> <a href="#example-AlcaDesign" title="Examples">💡</a> <a href="https://github.com/ml5js/ml5-library/commits?author=AlcaDesign" title="Tests">⚠️</a></td>
    <td align="center"><a href="http://www.memo.tv"><img src="https://avatars0.githubusercontent.com/u/144230?v=4" width="100px;" alt=""/><br /><sub><b>Memo Akten</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=memo" title="Code">💻</a> <a href="#example-memo" title="Examples">💡</a></td>
    <td align="center"><a href="https://thehidden1.github.io/"><img src="https://avatars0.githubusercontent.com/u/31354864?v=4" width="100px;" alt=""/><br /><sub><b>Mohamed Amine</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=TheHidden1" title="Code">💻</a> <a href="#example-TheHidden1" title="Examples">💡</a> <a href="#ideas-TheHidden1" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/ml5js/ml5-library/commits?author=TheHidden1" title="Tests">⚠️</a></td>
    <td align="center"><a href="http://meiamso.me"><img src="https://avatars3.githubusercontent.com/u/1187491?v=4" width="100px;" alt=""/><br /><sub><b>Oliver Wright</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=meiamsome" title="Code">💻</a> <a href="https://github.com/ml5js/ml5-library/commits?author=meiamsome" title="Tests">⚠️</a></td>
    <td align="center"><a href="https://marshalhayes.dev"><img src="https://avatars0.githubusercontent.com/u/17213165?v=4" width="100px;" alt=""/><br /><sub><b>Marshal Hayes</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=marshalhayes" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://reiinakano.github.io"><img src="https://avatars0.githubusercontent.com/u/18363734?v=4" width="100px;" alt=""/><br /><sub><b>Reiichiro Nakano</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=reiinakano" title="Code">💻</a> <a href="https://github.com/ml5js/ml5-library/commits?author=reiinakano" title="Tests">⚠️</a> <a href="#example-reiinakano" title="Examples">💡</a></td>
    <td align="center"><a href="https://deeplearnjs.org/"><img src="https://avatars0.githubusercontent.com/u/1100749?v=4" width="100px;" alt=""/><br /><sub><b>Nikhil Thorat</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=nsthorat" title="Code">💻</a> <a href="#example-nsthorat" title="Examples">💡</a> <a href="#ideas-nsthorat" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-nsthorat" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
    <td align="center"><a href="http://www.irenealvarado.com"><img src="https://avatars2.githubusercontent.com/u/8978670?v=4" width="100px;" alt=""/><br /><sub><b>Irene Alvarado</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=irealva" title="Code">💻</a> <a href="#example-irealva" title="Examples">💡</a> <a href="#maintenance-irealva" title="Maintenance">🚧</a> <a href="#ideas-irealva" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://www.vndrewlee.com/"><img src="https://avatars0.githubusercontent.com/u/6391516?v=4" width="100px;" alt=""/><br /><sub><b>Andrew Lee</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=vndrewlee" title="Code">💻</a> <a href="#example-vndrewlee" title="Examples">💡</a> <a href="#ideas-vndrewlee" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://medium.com/@fjcamillo.dev"><img src="https://avatars2.githubusercontent.com/u/12166244?v=4" width="100px;" alt=""/><br /><sub><b>Jerhone</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=fjcamillo" title="Documentation">📖</a></td>
    <td align="center"><a href="https://scalarvectortensor.net/"><img src="https://avatars1.githubusercontent.com/u/3594463?v=4" width="100px;" alt=""/><br /><sub><b>achimkoh</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=achimkoh" title="Code">💻</a> <a href="#example-achimkoh" title="Examples">💡</a> <a href="https://github.com/ml5js/ml5-library/commits?author=achimkoh" title="Tests">⚠️</a></td>
    <td align="center"><a href="http://ixora.io"><img src="https://avatars3.githubusercontent.com/u/4044283?v=4" width="100px;" alt=""/><br /><sub><b>Jim</b></sub></a><br /><a href="#example-hx2A" title="Examples">💡</a> <a href="https://github.com/ml5js/ml5-library/commits?author=hx2A" title="Documentation">📖</a> <a href="#content-hx2A" title="Content">🖋</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/champierre/resume"><img src="https://avatars1.githubusercontent.com/u/10215?v=4" width="100px;" alt=""/><br /><sub><b>Junya Ishihara</b></sub></a><br /><a href="#maintenance-champierre" title="Maintenance">🚧</a> <a href="https://github.com/ml5js/ml5-library/commits?author=champierre" title="Code">💻</a></td>
    <td align="center"><a href="http://naotohieda.com"><img src="https://avatars3.githubusercontent.com/u/1835081?v=4" width="100px;" alt=""/><br /><sub><b>Naoto HIÉDA</b></sub></a><br /><a href="#maintenance-micuat" title="Maintenance">🚧</a></td>
    <td align="center"><a href="http://montoyamoraga.io"><img src="https://avatars3.githubusercontent.com/u/3926350?v=4" width="100px;" alt=""/><br /><sub><b>aarón montoya-moraga</b></sub></a><br /><a href="#maintenance-montoyamoraga" title="Maintenance">🚧</a> <a href="#example-montoyamoraga" title="Examples">💡</a></td>
    <td align="center"><a href="http://b2renger.github.io/"><img src="https://avatars2.githubusercontent.com/u/1818874?v=4" width="100px;" alt=""/><br /><sub><b>b2renger</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=b2renger" title="Code">💻</a> <a href="#infra-b2renger" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
    <td align="center"><a href="http://adityasharma.me"><img src="https://avatars1.githubusercontent.com/u/24931529?v=4" width="100px;" alt=""/><br /><sub><b>Aditya Sharma</b></sub></a><br /><a href="#maintenance-adityaas26" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/okuna291"><img src="https://avatars1.githubusercontent.com/u/5407359?v=4" width="100px;" alt=""/><br /><sub><b>okuna291</b></sub></a><br /><a href="#ideas-okuna291" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://www.xujenna.com"><img src="https://avatars2.githubusercontent.com/u/13280722?v=4" width="100px;" alt=""/><br /><sub><b>Jenna</b></sub></a><br /><a href="#ideas-xujenna" title="Ideas, Planning, & Feedback">🤔</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/nicoleflloyd"><img src="https://avatars3.githubusercontent.com/u/35693567?v=4" width="100px;" alt=""/><br /><sub><b>nicoleflloyd</b></sub></a><br /><a href="#content-nicoleflloyd" title="Content">🖋</a> <a href="#design-nicoleflloyd" title="Design">🎨</a> <a href="#userTesting-nicoleflloyd" title="User Testing">📓</a></td>
    <td align="center"><a href="http://jepster.dk"><img src="https://avatars3.githubusercontent.com/u/7010555?v=4" width="100px;" alt=""/><br /><sub><b>jepster-dk</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=jepster-dk" title="Code">💻</a> <a href="#ideas-jepster-dk" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://xanderjakeq.page/"><img src="https://avatars1.githubusercontent.com/u/13279523?v=4" width="100px;" alt=""/><br /><sub><b>Xander Jake de los Santos</b></sub></a><br /><a href="#ideas-xanderjakeq" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/catarak"><img src="https://avatars1.githubusercontent.com/u/6063380?v=4" width="100px;" alt=""/><br /><sub><b>Cassie Tarakajian</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3Acatarak" title="Bug reports">🐛</a> <a href="#infra-catarak" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#ideas-catarak" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://davebsoft.com"><img src="https://avatars0.githubusercontent.com/u/55099?v=4" width="100px;" alt=""/><br /><sub><b>Dave Briccetti</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3Adcbriccetti" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://github.com/Sblob1"><img src="https://avatars0.githubusercontent.com/u/38335473?v=4" width="100px;" alt=""/><br /><sub><b>Sblob1</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3ASblob1" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://www.jwilber.me/"><img src="https://avatars2.githubusercontent.com/u/8595819?v=4" width="100px;" alt=""/><br /><sub><b>Jared Wilber</b></sub></a><br /><a href="#example-jwilber" title="Examples">💡</a> <a href="#ideas-jwilber" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/ml5js/ml5-library/commits?author=jwilber" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/tezzutezzu"><img src="https://avatars2.githubusercontent.com/u/135866?v=4" width="100px;" alt=""/><br /><sub><b>danilo</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=tezzutezzu" title="Code">💻</a> <a href="#ideas-tezzutezzu" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/EmmaGoodliffe"><img src="https://avatars1.githubusercontent.com/u/32788926?v=4" width="100px;" alt=""/><br /><sub><b>Emma Goodliffe</b></sub></a><br /><a href="#ideas-EmmaGoodliffe" title="Ideas, Planning, & Feedback">🤔</a> <a href="#question-EmmaGoodliffe" title="Answering Questions">💬</a> <a href="#maintenance-EmmaGoodliffe" title="Maintenance">🚧</a></td>
    <td align="center"><a href="http://yangyang.blog"><img src="https://avatars3.githubusercontent.com/u/9332910?v=4" width="100px;" alt=""/><br /><sub><b>Yang</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=EonYang" title="Code">💻</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3AEonYang" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://github.com/lydiajessup"><img src="https://avatars3.githubusercontent.com/u/26204298?v=4" width="100px;" alt=""/><br /><sub><b>Lydia Jessup</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=lydiajessup" title="Code">💻</a> <a href="#ideas-lydiajessup" title="Ideas, Planning, & Feedback">🤔</a> <a href="#example-lydiajessup" title="Examples">💡</a></td>
    <td align="center"><a href="https://coding.garden"><img src="https://avatars0.githubusercontent.com/u/14241866?v=4" width="100px;" alt=""/><br /><sub><b>CJ R.</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=w3cj" title="Documentation">📖</a> <a href="#content-w3cj" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/badunit"><img src="https://avatars2.githubusercontent.com/u/44651201?v=4" width="100px;" alt=""/><br /><sub><b>Fabio Corona</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3Abadunit" title="Bug reports">🐛</a></td>
    <td align="center"><a href="http://tnickel.de/"><img src="https://avatars3.githubusercontent.com/u/4189801?v=4" width="100px;" alt=""/><br /><sub><b>Tobias Nickel</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3ATobiasNickel" title="Bug reports">🐛</a> <a href="https://github.com/ml5js/ml5-library/commits?author=TobiasNickel" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://wakatime.com/@barakplasma"><img src="https://avatars0.githubusercontent.com/u/62937?v=4" width="100px;" alt=""/><br /><sub><b>Michael Salaverry</b></sub></a><br /><a href="#content-barakplasma" title="Content">🖋</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3Abarakplasma" title="Bug reports">🐛</a></td>
    <td align="center"><a href="http://sankeybuilder.com"><img src="https://avatars2.githubusercontent.com/u/1794620?v=4" width="100px;" alt=""/><br /><sub><b>Rob</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3Aeformx" title="Bug reports">🐛</a> <a href="#question-eformx" title="Answering Questions">💬</a></td>
    <td align="center"><a href="http://pujaa.rajan@gmail.com"><img src="https://avatars3.githubusercontent.com/u/10352446?v=4" width="100px;" alt=""/><br /><sub><b>Pujaa Rajan</b></sub></a><br /><a href="#example-pujaarajan" title="Examples">💡</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3Apujaarajan" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://mcintyre.io"><img src="https://avatars3.githubusercontent.com/u/3719176?v=4" width="100px;" alt=""/><br /><sub><b>Nick McIntyre</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=nickmcintyre" title="Tests">⚠️</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3Anickmcintyre" title="Bug reports">🐛</a></td>
    <td align="center"><a href="http://waxy.org/"><img src="https://avatars2.githubusercontent.com/u/6759?v=4" width="100px;" alt=""/><br /><sub><b>Andy Baio</b></sub></a><br /><a href="#content-waxpancake" title="Content">🖋</a> <a href="#maintenance-waxpancake" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://www.wenqi.li"><img src="https://avatars1.githubusercontent.com/u/22087042?v=4" width="100px;" alt=""/><br /><sub><b>Wenqi Li</b></sub></a><br /><a href="#content-wenqili" title="Content">🖋</a> <a href="https://github.com/ml5js/ml5-library/commits?author=wenqili" title="Code">💻</a> <a href="#infra-wenqili" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#maintenance-wenqili" title="Maintenance">🚧</a> <a href="#ideas-wenqili" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/garym140"><img src="https://avatars1.githubusercontent.com/u/30574513?v=4" width="100px;" alt=""/><br /><sub><b>garym140</b></sub></a><br /><a href="#design-garym140" title="Design">🎨</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/nicoleflloyd"><img src="https://avatars3.githubusercontent.com/u/35693567?v=4" width="100px;" alt=""/><br /><sub><b>nicoleflloyd</b></sub></a><br /><a href="#design-nicoleflloyd" title="Design">🎨</a></td>
    <td align="center"><a href="http://ixora.io"><img src="https://avatars3.githubusercontent.com/u/4044283?v=4" width="100px;" alt=""/><br /><sub><b>Jim</b></sub></a><br /><a href="#content-hx2A" title="Content">🖋</a> <a href="#maintenance-hx2A" title="Maintenance">🚧</a> <a href="#ideas-hx2A" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://medium.com/@s1thsv"><img src="https://avatars1.githubusercontent.com/u/855011?v=4" width="100px;" alt=""/><br /><sub><b>Yeswanth </b></sub></a><br /><a href="#maintenance-yeswanth" title="Maintenance">🚧</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3Ayeswanth" title="Bug reports">🐛</a></td>
    <td align="center"><a href="http://psherlock.com.br"><img src="https://avatars0.githubusercontent.com/u/6400794?v=4" width="100px;" alt=""/><br /><sub><b>Pettrus Sherlock</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3APettrus" title="Bug reports">🐛</a> <a href="#maintenance-Pettrus" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/tezzutezzu"><img src="https://avatars2.githubusercontent.com/u/135866?v=4" width="100px;" alt=""/><br /><sub><b>danilo</b></sub></a><br /><a href="#content-tezzutezzu" title="Content">🖋</a></td>
    <td align="center"><a href="http://andreasrefsgaard.dk"><img src="https://avatars2.githubusercontent.com/u/9645568?v=4" width="100px;" alt=""/><br /><sub><b>Andreas Refsgaard</b></sub></a><br /><a href="#content-AndreasRef" title="Content">🖋</a></td>
    <td align="center"><a href="http://bcjordan.com"><img src="https://avatars2.githubusercontent.com/u/206973?v=4" width="100px;" alt=""/><br /><sub><b>Brian Jordan</b></sub></a><br /><a href="#content-bcjordan" title="Content">🖋</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://bradley.im"><img src="https://avatars0.githubusercontent.com/u/8131020?v=4" width="100px;" alt=""/><br /><sub><b>bradley inniss</b></sub></a><br /><a href="#content-ratley" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/Kaushl2208"><img src="https://avatars0.githubusercontent.com/u/41343571?v=4" width="100px;" alt=""/><br /><sub><b>Kaushlendra Pratap</b></sub></a><br /><a href="#content-Kaushl2208" title="Content">🖋</a></td>
    <td align="center"><a href="http://twitter.com/maxdevjs"><img src="https://avatars2.githubusercontent.com/u/22229196?v=4" width="100px;" alt=""/><br /><sub><b>maxdevjs</b></sub></a><br /><a href="#content-maxdevjs" title="Content">🖋</a></td>
    <td align="center"><a href="http://about.me/joshuaweinstein/"><img src="https://avatars0.githubusercontent.com/u/175075?v=4" width="100px;" alt=""/><br /><sub><b>josher19</b></sub></a><br /><a href="#content-josher19" title="Content">🖋</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3Ajosher19" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://www.enigmeta.com"><img src="https://avatars3.githubusercontent.com/u/8477?v=4" width="100px;" alt=""/><br /><sub><b>Frederik De Bleser</b></sub></a><br /><a href="#content-fdb" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/violetcraze"><img src="https://avatars1.githubusercontent.com/u/43045568?v=4" width="100px;" alt=""/><br /><sub><b>Violet</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3Avioletcraze" title="Bug reports">🐛</a></td>
    <td align="center"><a href="http://tirtawr.com"><img src="https://avatars1.githubusercontent.com/u/6989378?v=4" width="100px;" alt=""/><br /><sub><b>Tirta Wening Rachman</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=tirtawr" title="Code">💻</a> <a href="#content-tirtawr" title="Content">🖋</a> <a href="#ideas-tirtawr" title="Ideas, Planning, & Feedback">🤔</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://kruschel.dev"><img src="https://avatars0.githubusercontent.com/u/20423069?v=4" width="100px;" alt=""/><br /><sub><b>Miká Kruschel</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=mikakruschel" title="Code">💻</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3Amikakruschel" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://github.com/tasanuma"><img src="https://avatars1.githubusercontent.com/u/11712443?v=4" width="100px;" alt=""/><br /><sub><b>Takanobu Asanuma</b></sub></a><br /><a href="#content-tasanuma" title="Content">🖋</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/martinloesethjensen/"><img src="https://avatars1.githubusercontent.com/u/31356774?v=4" width="100px;" alt=""/><br /><sub><b>Martin L. Jensen</b></sub></a><br /><a href="#content-martinloesethjensen" title="Content">🖋</a></td>
    <td align="center"><a href="https://adaptive.link"><img src="https://avatars1.githubusercontent.com/u/17833?v=4" width="100px;" alt=""/><br /><sub><b>Hugo Romano</b></sub></a><br /><a href="#content-adaptive" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/RaisinTen"><img src="https://avatars0.githubusercontent.com/u/42526976?v=4" width="100px;" alt=""/><br /><sub><b>Darshan Sen</b></sub></a><br /><a href="#content-RaisinTen" title="Content">🖋</a></td>
    <td align="center"><a href="https://twitter.com/ludwig_stumpp"><img src="https://avatars1.githubusercontent.com/u/42147848?v=4" width="100px;" alt=""/><br /><sub><b>Ludwig Stumpp</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/pulls?q=is%3Apr+reviewed-by%3ALudwigStumpp" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/ml5js/ml5-library/issues?q=author%3ALudwigStumpp" title="Bug reports">🐛</a> <a href="#example-LudwigStumpp" title="Examples">💡</a></td>
    <td align="center"><a href="http://bomani.xyz/"><img src="https://avatars1.githubusercontent.com/u/6589909?v=4" width="100px;" alt=""/><br /><sub><b>Bomani Oseni McClendon</b></sub></a><br /><a href="#content-bomanimc" title="Content">🖋</a> <a href="https://github.com/ml5js/ml5-library/commits?author=bomanimc" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://jhaemin.com"><img src="https://avatars3.githubusercontent.com/u/19797697?v=4" width="100px;" alt=""/><br /><sub><b>Jang Haemin</b></sub></a><br /><a href="#content-jhaemin" title="Content">🖋</a></td>
    <td align="center"><a href="http://antonfilatov.com"><img src="https://avatars1.githubusercontent.com/u/1931343?v=4" width="100px;" alt=""/><br /><sub><b>Anton Filatov</b></sub></a><br /><a href="#content-fannt" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/ELI7VH"><img src="https://avatars2.githubusercontent.com/u/11658002?v=4" width="100px;" alt=""/><br /><sub><b>Elijah Lucian</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/commits?author=ELI7VH" title="Documentation">📖</a></td>
    <td align="center"><a href="http://tambuildsthings.com"><img src="https://avatars1.githubusercontent.com/u/11823786?v=4" width="100px;" alt=""/><br /><sub><b>Tam</b></sub></a><br /><a href="#content-tambuildsthings" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/VishnuRaghavan"><img src="https://avatars1.githubusercontent.com/u/23146562?v=4" width="100px;" alt=""/><br /><sub><b>RGV</b></sub></a><br /><a href="#question-VishnuRaghavan" title="Answering Questions">💬</a></td>
    <td align="center"><a href="https://github.com/hansvana"><img src="https://avatars0.githubusercontent.com/u/10974059?v=4" width="100px;" alt=""/><br /><sub><b>hansvana</b></sub></a><br /><a href="#content-hansvana" title="Content">🖋</a></td>
    <td align="center"><a href="http://alikarpuzoglu.com"><img src="https://avatars2.githubusercontent.com/u/9629776?v=4" width="100px;" alt=""/><br /><sub><b>Ali Karpuzoglu</b></sub></a><br /><a href="https://github.com/ml5js/ml5-library/issues?q=author%3AAliKarpuzoglu" title="Bug reports">🐛</a> <a href="#maintenance-AliKarpuzoglu" title="Maintenance">🚧</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://wysko.org"><img src="https://avatars0.githubusercontent.com/u/31376393?v=4" width="100px;" alt=""/><br /><sub><b>Jacob Wysko</b></sub></a><br /><a href="#content-wyskoj" title="Content">🖋</a></td>
  </tr>
</table>

<!-- markdownlint-enable -->
<!-- prettier-ignore-end -->
<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
