import { Directive, ViewContainerRef, TemplateRef, Renderer, Input } from '@angular/core';
import { autorun } from 'mobx';
import { mobxAngularDebug } from '../utils/mobx-angular-debug';
var MobxAutorunDirective = /** @class */ (function () {
    function MobxAutorunDirective(templateRef, viewContainer, renderer) {
        this.templateRef = templateRef;
        this.viewContainer = viewContainer;
        this.renderer = renderer;
        this.templateBindings = {};
    }
    MobxAutorunDirective.prototype.ngOnInit = function () {
        this.view = this.viewContainer.createEmbeddedView(this.templateRef);
        if (this.dispose)
            this.dispose();
        if (this.shouldDetach()) {
            this.view.detach();
        }
        this.autoDetect(this.view);
        mobxAngularDebug(this.view, this.renderer, this.dispose);
    };
    MobxAutorunDirective.prototype.shouldDetach = function () {
        return this.mobxAutorun && this.mobxAutorun.detach;
    };
    MobxAutorunDirective.prototype.autoDetect = function (view) {
        var autorunName = view._view.component
            ? view._view.component.constructor.name + ".detectChanges()" // angular 4+
            : view._view.parentView.context.constructor.name + ".detectChanges()"; // angular 2
        this.dispose = autorun(autorunName, function () { return view['detectChanges'](); });
    };
    MobxAutorunDirective.prototype.ngOnDestroy = function () {
        if (this.dispose)
            this.dispose();
    };
    MobxAutorunDirective.decorators = [
        { type: Directive, args: [{ selector: '[mobxAutorun]' },] },
    ];
    /** @nocollapse */
    MobxAutorunDirective.ctorParameters = function () { return [
        { type: TemplateRef, },
        { type: ViewContainerRef, },
        { type: Renderer, },
    ]; };
    MobxAutorunDirective.propDecorators = {
        'mobxAutorun': [{ type: Input },],
    };
    return MobxAutorunDirective;
}());
export { MobxAutorunDirective };
//# sourceMappingURL=data:application/json;base64,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