import { Directive, Input } from '@angular/core';
import { autorun } from 'mobx';
import * as i0 from "@angular/core";
// import { mobxAngularDebug } from '../utils/mobx-angular-debug';
export class MobxAutorunDirective {
    constructor(templateRef, viewContainer) {
        Object.defineProperty(this, "templateRef", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: templateRef
        });
        Object.defineProperty(this, "viewContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: viewContainer
        });
        Object.defineProperty(this, "templateBindings", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(this, "dispose", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "view", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "allAutorunOptions", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: [
                'delay',
                'scheduler',
                'requiresObservable',
                'name',
                'onError'
            ]
        });
        Object.defineProperty(this, "mobxAutorun", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
    }
    ngOnInit() {
        this.view = this.viewContainer.createEmbeddedView(this.templateRef);
        if (this.dispose) {
            this.dispose();
        }
        if (this.shouldDetach()) {
            this.view.detach();
        }
        this.autoDetect(this.view);
        // mobxAngularDebug(this.view, this.dispose);
    }
    shouldDetach() {
        return this.mobxAutorun && this.mobxAutorun.detach;
    }
    autoDetect(view) {
        const opts = this.getAutorunOptions();
        this.dispose = autorun(() => view.detectChanges(), opts);
    }
    getAutorunOptions() {
        return Object.keys(this.mobxAutorun || {}).reduce((opts, current) => {
            if (this.allAutorunOptions.includes(current)) {
                opts[current] = this.mobxAutorun[current];
            }
            return opts;
        }, {});
    }
    ngOnDestroy() {
        if (this.dispose) {
            this.dispose();
        }
    }
}
Object.defineProperty(MobxAutorunDirective, "\u0275fac", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxAutorunDirective, deps: [{ token: i0.TemplateRef }, { token: i0.ViewContainerRef }], target: i0.ɵɵFactoryTarget.Directive })
});
Object.defineProperty(MobxAutorunDirective, "\u0275dir", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.0", type: MobxAutorunDirective, selector: "[mobxAutorun]", inputs: { mobxAutorun: "mobxAutorun" }, ngImport: i0 })
});
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxAutorunDirective, decorators: [{
            type: Directive,
            args: [{ selector: '[mobxAutorun]' }]
        }], ctorParameters: function () { return [{ type: i0.TemplateRef }, { type: i0.ViewContainerRef }]; }, propDecorators: { mobxAutorun: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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