import { Directive, Input } from '@angular/core';
import { reaction } from 'mobx';
import { MobxAutorunDirective } from './mobx-autorun.directive';
import * as i0 from "@angular/core";
export class MobxReactionDirective extends MobxAutorunDirective {
    constructor(templateRef, viewContainer) {
        super(templateRef, viewContainer);
        Object.defineProperty(this, "templateRef", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: templateRef
        });
        Object.defineProperty(this, "viewContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: viewContainer
        });
        Object.defineProperty(this, "mobxReaction", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "mobxReactionOptions", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
    }
    autoDetect(view) {
        const opts = Object.assign({ fireImmediately: true }, this.mobxReactionOptions);
        this.dispose = reaction(this.mobxReaction, () => {
            view.detectChanges();
        }, opts);
    }
}
Object.defineProperty(MobxReactionDirective, "\u0275fac", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxReactionDirective, deps: [{ token: i0.TemplateRef }, { token: i0.ViewContainerRef }], target: i0.ɵɵFactoryTarget.Directive })
});
Object.defineProperty(MobxReactionDirective, "\u0275dir", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.0", type: MobxReactionDirective, selector: "[mobxReaction]", inputs: { mobxReaction: "mobxReaction", mobxReactionOptions: "mobxReactionOptions" }, usesInheritance: true, ngImport: i0 })
});
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxReactionDirective, decorators: [{
            type: Directive,
            args: [{ selector: '[mobxReaction]' }]
        }], ctorParameters: function () { return [{ type: i0.TemplateRef }, { type: i0.ViewContainerRef }]; }, propDecorators: { mobxReaction: [{
                type: Input
            }], mobxReactionOptions: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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