import { Injectable } from '@angular/core';
import { makeAutoObservable } from 'mobx';
import { NavigationEnd } from '@angular/router';
import { filter } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
export class RouterStore {
    constructor(router, activatedRoute) {
        Object.defineProperty(this, "router", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: router
        });
        Object.defineProperty(this, "activatedRoute", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: activatedRoute
        });
        Object.defineProperty(this, "url", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: ''
        });
        Object.defineProperty(this, "routeSnapshot", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        makeAutoObservable(this);
        router.events
            .pipe(filter((event) => event instanceof NavigationEnd))
            .subscribe((e) => this.routeListener(e));
    }
    routeListener(event) {
        this.routeSnapshot = this.activatedRoute.snapshot;
        this.url = event.urlAfterRedirects;
    }
}
Object.defineProperty(RouterStore, "\u0275fac", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: RouterStore, deps: [{ token: i1.Router }, { token: i1.ActivatedRoute }], target: i0.ɵɵFactoryTarget.Injectable })
});
Object.defineProperty(RouterStore, "\u0275prov", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: RouterStore, providedIn: 'root' })
});
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: RouterStore, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }], ctorParameters: function () { return [{ type: i1.Router }, { type: i1.ActivatedRoute }]; } });
//# sourceMappingURL=data:application/json;base64,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