import { autorun, reaction, makeAutoObservable, action as action$1, computed as computed$1, observable as observable$1 } from 'mobx';
import * as i0 from '@angular/core';
import { Directive, Input, Injectable, NgModule } from '@angular/core';
import * as i1 from '@angular/router';
import { NavigationEnd } from '@angular/router';
import { filter } from 'rxjs/operators';

// import { mobxAngularDebug } from '../utils/mobx-angular-debug';
class MobxAutorunDirective {
    constructor(templateRef, viewContainer) {
        Object.defineProperty(this, "templateRef", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: templateRef
        });
        Object.defineProperty(this, "viewContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: viewContainer
        });
        Object.defineProperty(this, "templateBindings", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(this, "dispose", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "view", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "allAutorunOptions", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: [
                'delay',
                'scheduler',
                'requiresObservable',
                'name',
                'onError'
            ]
        });
        Object.defineProperty(this, "mobxAutorun", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
    }
    ngOnInit() {
        this.view = this.viewContainer.createEmbeddedView(this.templateRef);
        if (this.dispose) {
            this.dispose();
        }
        if (this.shouldDetach()) {
            this.view.detach();
        }
        this.autoDetect(this.view);
        // mobxAngularDebug(this.view, this.dispose);
    }
    shouldDetach() {
        return this.mobxAutorun && this.mobxAutorun.detach;
    }
    autoDetect(view) {
        const opts = this.getAutorunOptions();
        this.dispose = autorun(() => view.detectChanges(), opts);
    }
    getAutorunOptions() {
        return Object.keys(this.mobxAutorun || {}).reduce((opts, current) => {
            if (this.allAutorunOptions.includes(current)) {
                opts[current] = this.mobxAutorun[current];
            }
            return opts;
        }, {});
    }
    ngOnDestroy() {
        if (this.dispose) {
            this.dispose();
        }
    }
}
Object.defineProperty(MobxAutorunDirective, "\u0275fac", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxAutorunDirective, deps: [{ token: i0.TemplateRef }, { token: i0.ViewContainerRef }], target: i0.ɵɵFactoryTarget.Directive })
});
Object.defineProperty(MobxAutorunDirective, "\u0275dir", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.0", type: MobxAutorunDirective, selector: "[mobxAutorun]", inputs: { mobxAutorun: "mobxAutorun" }, ngImport: i0 })
});
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxAutorunDirective, decorators: [{
            type: Directive,
            args: [{ selector: '[mobxAutorun]' }]
        }], ctorParameters: function () { return [{ type: i0.TemplateRef }, { type: i0.ViewContainerRef }]; }, propDecorators: { mobxAutorun: [{
                type: Input
            }] } });

class MobxReactionDirective extends MobxAutorunDirective {
    constructor(templateRef, viewContainer) {
        super(templateRef, viewContainer);
        Object.defineProperty(this, "templateRef", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: templateRef
        });
        Object.defineProperty(this, "viewContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: viewContainer
        });
        Object.defineProperty(this, "mobxReaction", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "mobxReactionOptions", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
    }
    autoDetect(view) {
        const opts = Object.assign({ fireImmediately: true }, this.mobxReactionOptions);
        this.dispose = reaction(this.mobxReaction, () => {
            view.detectChanges();
        }, opts);
    }
}
Object.defineProperty(MobxReactionDirective, "\u0275fac", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxReactionDirective, deps: [{ token: i0.TemplateRef }, { token: i0.ViewContainerRef }], target: i0.ɵɵFactoryTarget.Directive })
});
Object.defineProperty(MobxReactionDirective, "\u0275dir", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.0", type: MobxReactionDirective, selector: "[mobxReaction]", inputs: { mobxReaction: "mobxReaction", mobxReactionOptions: "mobxReactionOptions" }, usesInheritance: true, ngImport: i0 })
});
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxReactionDirective, decorators: [{
            type: Directive,
            args: [{ selector: '[mobxReaction]' }]
        }], ctorParameters: function () { return [{ type: i0.TemplateRef }, { type: i0.ViewContainerRef }]; }, propDecorators: { mobxReaction: [{
                type: Input
            }], mobxReactionOptions: [{
                type: Input
            }] } });

class RouterStore {
    constructor(router, activatedRoute) {
        Object.defineProperty(this, "router", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: router
        });
        Object.defineProperty(this, "activatedRoute", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: activatedRoute
        });
        Object.defineProperty(this, "url", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: ''
        });
        Object.defineProperty(this, "routeSnapshot", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        makeAutoObservable(this);
        router.events
            .pipe(filter((event) => event instanceof NavigationEnd))
            .subscribe((e) => this.routeListener(e));
    }
    routeListener(event) {
        this.routeSnapshot = this.activatedRoute.snapshot;
        this.url = event.urlAfterRedirects;
    }
}
Object.defineProperty(RouterStore, "\u0275fac", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: RouterStore, deps: [{ token: i1.Router }, { token: i1.ActivatedRoute }], target: i0.ɵɵFactoryTarget.Injectable })
});
Object.defineProperty(RouterStore, "\u0275prov", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: RouterStore, providedIn: 'root' })
});
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: RouterStore, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }], ctorParameters: function () { return [{ type: i1.Router }, { type: i1.ActivatedRoute }]; } });

const DIRECTIVES = [MobxAutorunDirective, MobxReactionDirective];
class MobxAngularModule {
}
Object.defineProperty(MobxAngularModule, "\u0275fac", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxAngularModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule })
});
Object.defineProperty(MobxAngularModule, "\u0275mod", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxAngularModule, declarations: [MobxAutorunDirective, MobxReactionDirective], exports: [MobxAutorunDirective, MobxReactionDirective] })
});
Object.defineProperty(MobxAngularModule, "\u0275inj", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxAngularModule })
});
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.0", ngImport: i0, type: MobxAngularModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: DIRECTIVES,
                    exports: DIRECTIVES
                }]
        }] });

/*
 * Public API Surface of mobx-angular
 */
// Re-export mobx operators to be able to use inside components with AOT:
function actionInternal(...args) {
    return action$1(...args);
}
const action = Object.assign(actionInternal, action$1);
function computedInternal(...args) {
    return computed$1(...args);
}
const computed = Object.assign(computedInternal, computed$1);
function observableInternal(...args) {
    return observable$1(...args);
}
const observable = Object.assign(observableInternal, observable$1);

/**
 * Generated bundle index. Do not edit.
 */

export { MobxAngularModule, MobxAutorunDirective, MobxReactionDirective, RouterStore, action, actionInternal, computed, observable };
//# sourceMappingURL=mobx-angular.mjs.map
