"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./utils/assertEnvironment");
var reactBatchedUpdates_1 = require("./utils/reactBatchedUpdates");
var observerBatching_1 = require("./utils/observerBatching");
var utils_1 = require("./utils/utils");
var useObserver_1 = require("./useObserver");
observerBatching_1.observerBatching(reactBatchedUpdates_1.unstable_batchedUpdates);
var staticRendering_1 = require("./staticRendering");
exports.isUsingStaticRendering = staticRendering_1.isUsingStaticRendering;
exports.useStaticRendering = staticRendering_1.useStaticRendering;
var observer_1 = require("./observer");
exports.observer = observer_1.observer;
var ObserverComponent_1 = require("./ObserverComponent");
exports.Observer = ObserverComponent_1.Observer;
var useLocalObservable_1 = require("./useLocalObservable");
exports.useLocalObservable = useLocalObservable_1.useLocalObservable;
var observerBatching_2 = require("./utils/observerBatching");
exports.observerBatching = observerBatching_2.observerBatching;
var useLocalStore_1 = require("./useLocalStore");
exports.useLocalStore = useLocalStore_1.useLocalStore;
var useAsObservableSource_1 = require("./useAsObservableSource");
exports.useAsObservableSource = useAsObservableSource_1.useAsObservableSource;
function useObserver(fn, baseComponentName) {
    if (baseComponentName === void 0) { baseComponentName = "observed"; }
    if ("production" !== process.env.NODE_ENV) {
        utils_1.useDeprecated("[mobx-react-lite] 'useObserver(fn)' is deprecated. Use `<Observer>{fn}</Observer>` instead, or wrap the entire component in `observer`.");
    }
    return useObserver_1.useObserver(fn, baseComponentName);
}
exports.useObserver = useObserver;
